/*
 *    File trbutton.cpp
 *      Demonstrates the use of the RBUTTON and RBUTTON Objects
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mguipp.h"

#include "mguitest.hpp"

#define N_TOGGLE_BUTTON	4

class RadioToggle : public CmCallback
{
    CmShell *shell;
public:
    RadioToggle();
    void closeDialog(void) { delete shell; delete this; };
};

class CaToggleButton:public CmToggleButton
{
public:
    CmLabel * label;
    int index;

    void onActivate(int armed);
      CaToggleButton(CmContainer * p, char *text, MTFont f = DEFAULT_FONT)
    : CmToggleButton(p, text, f)
    {
	setCallback(this, (INT_CB)&CaToggleButton::onActivate);
    };
    CaToggleButton(CmContainer * p, char *norm, char *arm, char *uns = 0)
    : CmToggleButton(p, norm, arm, uns)
    {
	setCallback(this, (INT_CB)&CaToggleButton::onActivate);
    };
};

class CaRadioButton:public CmRadioButton
{
    public:
    CmLabel * label;
    int index;
      protected:
    void onActivate(int armed);
      public:
      CaRadioButton(CmContainer * p, char *text, MTFont f = DEFAULT_FONT)
    : CmRadioButton(p, text, f)
    {
	setCallback(this, (INT_CB)&CaToggleButton::onActivate);
    };
    CaRadioButton(CmContainer * p, char *norm, char *arm, char *uns = 0)
    : CmRadioButton(p, norm, arm, uns)
    {
	setCallback(this, (INT_CB)&CaToggleButton::onActivate);
    };
};

int toggle_status[N_TOGGLE_BUTTON];

/*****************************************************
 *	This function handles the status change
 *	of a TBUTTON.
 *****************************************************/
void CaToggleButton::
onActivate(int status)
{
    char str[128];
    int i;

    toggle_status[index] = status;
    strcpy(str, "Status: ");
    for (i = 0; i < N_TOGGLE_BUTTON; i++)
	strcat(str, (toggle_status[i] ? "  ON" : " OFF"));
/*
 * The LABEL 'label' is updated with the current status of the toggle
 * buttons as it changes
 */
    label->setText(str);
}

/*****************************************************
 *	This function handles the status change
 *	of a RBUTTON.
 *****************************************************/
void CaRadioButton::
onActivate(int status)
{
    char str[64];

    if (status)
    {
/*
 * The LABEL 'label' shows which radio button is active
 */
	sprintf(str, "Selected the button %d", index);
	label->setText(str);
    }
}

RadioToggle::RadioToggle(void)
{
    int ii;
    char str[16];
    CmRowForm *rf, *rform;
    CmColForm *cform;
    CmSFile *sfile;
    CmLabel *label;
    CaToggleButton *tb;
    CaRadioButton *rb;
    CmPushButton *pb;

    shell = new CmShell("Toggle & Radio Buttons", SF_MODAL);

    cform = new CmColForm(shell);
    rform = new CmRowForm(cform);

    rf = new CmRowForm(rform);
    label = new CmLabel(rf, "", FIXED_MEDIUM);
    for (ii = 0; ii < N_TOGGLE_BUTTON; ii++)
    {
	sprintf(str, "Toggle %d", ii);
	tb = new CaToggleButton(rf, "normal.bmp", "armed.bmp", "unsens.bmp");
	tb->index = ii;
	tb->label = label;
    }
/*
 * Arm the last created toggle button
 * (this will also cause the 'label' text to
 * change accordingly)
 */
    tb->arm();

    rf = new CmRowForm(rform);
    label = new CmLabel(rf, "", FIXED_MEDIUM);
    for (ii = 0; ii < 4; ii++)
    {
	sprintf(str, "Radio %d", ii);
	rb = new CaRadioButton(rf, "normal.bmp", "armed.bmp", "unsens.bmp");
	rb->index = ii;
	rb->label = label;
    }
/*
 * Activate the last created radio button
 * (this will also cause the 'r_label' text to
 * change accordingly)
 */
    rb->arm();
/*
 * This SFILE Object shows this source file in the dialog
 */
    sfile = new CmSFile(cform, __FILE__, FIXED_MEDIUM, 10, 40);
    sfile->setColor(darkblue, white);
/*
 * This PUSH BUTTON closes the dialog
 */
    pb = new CmPushButton(shell, "Close", TIMES_MEDIUM);
    pb->setCallback(this, (VOID_CB)&RadioToggle::closeDialog);

    shell->realize();
}

/*****************************************************
 *	This function opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
void
RadioToggleDemo(void)
{
	new RadioToggle;
}
