/*
**  HOST.C (3/16/96)
**
**  Functions as a simple 1-line BBS.
*/

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <dos.h>
#include <string.h>
#include <conio.h>
#include "modem_io.h"
#include "session.h"
#include "pcl4c.h"

#define FALSE    0
#define TRUE     !FALSE
#define CTLZ     0x1a
#define ONE_SEC  18

/*** Global Variables ***/

int Port;                 /* COM Port */
int CharPace = 4;         /* inter-char delay in tics */
int BaudCode;             /* baud rate code ( index into BaudRate[] ) */
char *BaudRate[10] =  {"0","300","1200","2400","4800","9600",
                       "19200","38400","57600","115200"};
char AwaitMsg[] = "<<Awaiting caller (type ^Z to exit) >>";

/*** local prototypes ***/

int BaudMatch(char *);
void ErrorCheck(int);
void MyExit(char *);

/*** main ***/

void main(int argc, char *argv[])
{char c;
 int  i;
 char far *Ptr;
 int  Seg;
 int  Version;
 char Temp[80];
 /* begin */
 if(argc!=3)
   {printf("Usage: HOST <port> <baud>\n");
    exit(1);
   }
 /* get port number from command line */
 Port = atoi(argv[1]) - 1;
 if((Port<COM1) || (Port>COM20))
   {printf("Port must be COM1 to COM20n");
    exit(1);
   }
 /* get baud rate from command line */
 BaudCode = BaudMatch(argv[2]);
 if(BaudCode<0)
   {printf("Cannot recognize baud rate = %s\n",argv[2]);
    exit(1);
   }
 /* setup 1024 byte receive buffer */
 Ptr = (char far *) _fmalloc(1024+16);
 Seg = FP_SEG(Ptr) + ((FP_OFF(Ptr)+15)>>4);
 SioRxBuf(Port,Seg,Size1024);
 /* setup 128 byte transmit buffer */
 Ptr = (char far *) _fmalloc(128+16);
 Seg = FP_SEG(Ptr) + ((FP_OFF(Ptr)+15)>>4);
 SioTxBuf(Port,Seg,Size128);
 /* set port parmameters */
 ErrorCheck( SioParms(Port,NoParity,OneStopBit,WordLength8) );
 /* reset the port */
 ErrorCheck( SioReset(Port,BaudCode) );
 /* set DTR and RTS */
 ErrorCheck( SioDTR(Port,'S') );
 ErrorCheck( SioRTS(Port,'S') );
 /* display some info */
 printf("\nHOST (3/16/96)\n");
 Version = SioInfo('V');
 sprintf(Temp,"<<PCL4C ver %d.%d>>\n",Version>>4,0x0f&Version);
 printf(Temp);
 /* set hardware flow control */
 SioFlow(Port,10*ONE_SEC);
 /* Set FIFO level */
 if( SioFIFO(Port,LEVEL_14) ) printf("<<16550 detected>>\n");
 /* wait for Modem to say its ready */
 printf("<<Waiting for Modem DSR>>\n");
 while( !SioDSR(Port) )
   {if(kbhit()||SioBrkKey()) MyExit("Aborted by user");
    printf(".");
    SioDelay(ONE_SEC);
   }
 printf("\n<<Initializing modem>>\n");
 /* send initialization string to modem */
 ModemSendTo(Port,CharPace,"!!AT E1 S7=60 S11=60 V1 X1 Q0 S0=0!");
 if(ModemWaitFor(Port,5*ONE_SEC,FALSE,"OK"))
      printf("<<Modem is ready>>\n");
 else MyExit("<<Expected OK not received>>\n");
 /* echo characters in RX buffer */
 ModemEcho(Port,ONE_SEC);
 /* enter terminal loop */
 printf("%s\n",AwaitMsg);
 while(TRUE)
     {/* was key pressed ? */
      if(kbhit())
          {i = getch();
           if((char)i==CTLZ)
              {printf("\n<<Hanging up modem>>\n");
               ModemHangup(Port);
               /* restore COM port status & exit */
               SioDone(Port);
               exit(1);
              }
           else printf("<<type ^Z to abort>>\n");
          } /* end if */
      /* any incoming over serial port ? */
      i = SioGetc(Port,0);
      if(i>-1)
        {/* echo all incoming */
         putch((char)i);
         /* RING ? */
         if((char)i=='R')
           {/* might be RING */
            if(ModemWaitFor(Port,ONE_SEC,FALSE,"ING"))
              {Session(Port);
               ModemHangup(Port);
               printf("%s\n",AwaitMsg);
              }
           }
        }
     } /* end while */
} /* end main */

/*** check return code ***/

void ErrorCheck(int Code)
{/* trap PCL error codes */
 if(Code<0)
     {SioError(Code);
      SioDone(Port);
      exit(1);
     }
}

/*** find baud rate index ***/

int BaudMatch(char *P)
{int i;
 /* find baud rate in table */
 for(i=0;i<10;i++) if(strcmp(BaudRate[i],P)==0) return(i);
 return(-1);
}

/*** common exit ***/

void MyExit(char *S)
{printf("%s\n",S);
 SioDone(Port);
 exit(0);
}
