/*
 *                             PRINTER.C
 *
 *                           Written for the
 *
 *                              Datalight
 *                           Microsoft V 5.x
 *                                TurboC
 *                                  &
 *                               Zortech
 *
 *                             C Compilers
 *
 *            Copyright (c) John Birchfield 1987, 1988, 1989
 *
 * Output a character to the printer port using software interrupt
 * 0x17.  Returns -1 if unsuccessful, 0 otherwise.
 *
 * Usage while (print_char (ch));
 */
#include <dos.h>
#include "printer.h"

int 
print_char (ch)
char    ch;
{
    char    flag;
    union REGS regs;

    regs.x.dx = 0;
    regs.h.ah = 2;
    int86 (0x17, &regs, &regs);
    if (regs.h.ah != PR_SELECTED)
        return regs.h.ah;
    regs.x.dx = regs.h.ah = 0;
    regs.h.al = ch;
    int86 (0x17, &regs, &regs);
    return 0;
}
