/* dos_io.c */

#define BYTE unsigned char

#include  <stdio.h>
#include  <dos.h>

/* read keyboard */

char ReadKbd(void)
{union REGS  reg;
 reg.h.ah = 0;
 int86(0x16, &reg, &reg);
 return reg.x.ax;
}

/* set cursor type */

void SetCursor(BYTE Top,BYTE Bottom)
{union REGS  reg;
 reg.h.ah = 1;
 reg.h.ch = Top;
 reg.h.cl = Bottom;
 int86(0x10, &reg, &reg);
}

/* write character & attribute without advancing cursor */

void AttrWrite(BYTE ch, BYTE attr)
{union REGS  reg;
 reg.h.ah = 9;
 reg.h.bh = 0;        /* current text page */
 reg.h.al = ch;       /* character */
 reg.h.bl = attr;
 reg.x.cx = 1;
 int86(0x10, &reg, &reg);
}

/* position cursor at desired row & column */

void Position(BYTE row, BYTE col)
{union REGS reg;
 reg.h.ah = 2;
 reg.h.bh = 0;
 reg.h.dh = row;
 reg.h.dl = col;
 int86(0x10, &reg, &reg);
}

/* returns the current row of the cursor */

int GetRow()
{union  REGS  reg;
 reg.h.ah = 3;
 reg.h.bh = 0;
 int86(0x10, &reg, &reg);
 return(reg.h.dh);
}

/* returns the current column of the cursor */

int GetCol()
{union  REGS  reg;
 reg.h.ah = 3;
 reg.h.bh = 0;
 int86(0x10, &reg, &reg);
 return(reg.h.dl);
}

/* scrolls area specified # rows */

void Scroll(
   unsigned  urow,   /* upper row of area */
   unsigned  lcol,   /* left column of area */
   unsigned  lrow,   /* lower row of area */
   unsigned  rcol,   /* right column of area */
   int nrows,        /* # rows to scroll */
   int attr)         /* attribute to use for blank lines */
{union REGS reg;
 reg.h.ah = 6;
 reg.h.ch = urow;
 reg.h.cl = lcol;
 reg.h.al = nrows;
 reg.h.bh = attr;
 reg.h.dh = lrow;
 reg.h.dl = rcol;
 int86(0x10, &reg, &reg);
}

long FreeDiskSpace(void)
{union REGS reg;
 reg.h.ah = 0x36;
 reg.h.dl = 0;
 int86(0x21, &reg, &reg);
 if(reg.x.ax == 0xffff) return 0;
 return ( (long)reg.x.bx * (long)reg.x.ax * (long)reg.x.cx );
}
