include src\qlib.inc
include src\video.inc
include video.inc
include conio.inc
include alloc.inc

.code
t_savestate proc
  ;uses INT 10h func 1ch
  local buf:dword
  local bufsiz:dword
  local vbufsiz:dword
  pushad
  mov ax,1c00h
  mov cx,7
  int 10h
  cmp al,1ch
  jz good
bad:
  popad
  mov eax,NULL
  ret
good:
  shl bx,5   ;bx * 64
  .if bx>8*1024
    jmp bad
  .endif
  xor ecx,ecx
  mov cx,bx
  mov bufsiz,ecx
  add ecx,8  ;add some room for bufsiz/vbufsiz
  mov eax,ds:[44ch]   ;video buffer size in bytes
  mov vbufsiz,eax
  add ecx,eax
  callp malloc,ecx
  cmp eax,NULL
  jz bad
  mov buf,eax
  sub esp,sizeof callstruct
  mov dptr[esp].callstruct._sp,0  ;clear SS:SP
  mov wptr[esp].callstruct._eax,1c01h  ;save state
  mov bptr[esp].callstruct._ecx,7      ;save all info
  mov ax,_8kbufferseg
  mov wptr[esp].callstruct._es,ax
  mov wptr[esp].callstruct._ebx,0
  mov ax,300h
  mov bx,10h
  xor cx,cx
  mov edi,esp
  int 31h  ;call real mode INT
  .if carry?
    add esp,sizeof callstruct
    jmp bad
  .endif
  add esp,sizeof callstruct
  mov esi,_8kbuffer
  mov edi,buf
  mov eax,bufsiz
  mov [edi],eax
  mov eax,vbufsiz
  mov [edi+4],eax
  add edi,8
  mov ecx,bufsiz
  shr ecx,2  ;will be a multi of 64 anyways
  rep movsd
  mov esi,0b8000h
  mov ecx,vbufsiz
  copyECX  ;destroys AL
  popad
  mov eax,buf
  ret
t_savestate endp

t_restorestate proc,a:dword
  pushad
  mov esi,a
  mov edi,_8kbuffer
  mov ecx,[esi]
  add esi,8
  rep movsd
  sub esp,sizeof callstruct
  mov dptr[esp].callstruct._sp,0  ;clear SS:SP
  mov wptr[esp].callstruct._eax,1c02h  ;restore state
  mov bptr[esp].callstruct._ecx,7      ;restore all info
  mov ax,_8kbufferseg
  mov wptr[esp].callstruct._es,ax
  mov wptr[esp].callstruct._ebx,0
  mov ax,300h
  mov bx,10h
  xor cx,cx
  mov edi,esp
  int 31h  ;call real mode INT
  add esp,sizeof callstruct

  mov esi,a
  mov edi,0b8000h
  mov eax,[esi]
  mov ecx,[esi+4]
  add esi,eax
  add esi,8
  copyECX  ;destroys AL

  popad
  xor eax,eax
  ret
t_restorestate endp

_endseg

end
