#include <qlib.h>
#include <dos.h>
#include <conio.h>
#include <stdio.h>
#include <process.h>
#include <stdlib.h>
#include <string.h>

#include <lefile.h>     //LE header structure
#include <compress.h>   //compression header

#include "misc.h"
#include "parse.h"

sword hi,ho;
byte *bufi,*bufo;
char tempfn[0x80];
byte _tempfn=0;
byte ctyp=COMP_LZ;
struct LEHeader lehdr;

#define offset(x) &x            //this is kinda cool

void cleanup(void) {
  if (hi) close(hi);
  if (ho) close(ho);

  if (_tempfn) unlink(tempfn);
}

void usage(void) {
  printf("  Usage : QDLCOMP [options] dllfile[.QDL]\n");
  printf("   dllfile = file to compress\n");
  printf("  Options:\n"
  printf("   /c=<x>  = specify compression type\n");
  printf("  Compression Types:\n");
  printf("   STORE   = no compression\n");
  printf("   LZ      = LZ compression (default)\n");
  exit(0);
}

int CreatTemp(void) {
  char str[0x80];
  word a;
  int h;

  for (a=0;a<=999;a++) {
    sprintf(str,"$QDLCMP$.%03d",a);
    h=_creat(str,FA_ARCH);
    if (h!=-1) {
      strcpy(tempfn,str);
      _tempfn=1;  //cleanup() will now delete tempfn on error
      return h;
    }
  }

  error("Could not create a tempfile");

  return 0;  //just to shut-up compiler
}

void ReadLEHeader(void) {
  if (read(hi,offset(lehdr),sizeof(lehdr))!=sizeof(lehdr)) {
bad:
    error("Unable to read LE Header");
  }
  if (lehdr.LESignature!='LE') goto bad;
}

word main(byte argc,byte **args) {

  printf("Q/DLL Compressor v1.00  by:Peter Quiring\n");
  if ((argc>2)||(argc<1)) usage();

  parse_args();

  bufi=GetRam(bufsiz);
  bufo=GetRam(bufsiz);
  if ((arg_namesc!=1)||(arg_opts>1)) usage();

  if (arg_opts) {
    if (arg_opts[0][1]==NULL) usage();
    if (!stricmp(arg_opts[0][1],"LZ")) ctyp=COMP_LZ;
    elseif (!stricmp(arg_opts[0][1],"STORE")) ctyp=COMP_STORE;
    else usage();
  }

  hi=open(arg_names,O_RDONLY|O_BINARY);
  if (hi==-1) error("Opening infile");
  ho=CreatTemp();

  ReadLEHeader();

  SetupOutput();

  CompHeader();

  CompImage();

  close(ho);
  close(hi);

  RenameFile();  //rename temp file to old file.

  printf("Complete!\n");
  return 0;
}
