/****************************************************************************/
/* DEBUG                                                                    */
/*--------------------------------------------------------------------------*/
/* Fonctions de dbogage                                                    */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 05/03/95                                                    */
/****************************************************************************/

#include <iostream.h>


#include "Settings.h"

#ifndef NDEBUG

#include <conio.h>
#include <stdio.h>

#include "Types.h"

#include "JPAppli.h"

#include "Compat.h"
#include "Errors.h"
#include "Mouse.h"
#include "Screen.h"
#include "Sound.h"
#include "Strings.h"
#include "Vocab.h"

#include "Debug.h"

/*ͻ*/
/*                            VARIABLES STATIQUES                         */
/*ͼ*/

// Autorise ou non l'affichage de la mmoire disponible

static boolean s_memory_display=FALSE;

/*ͻ*/
/*                                 FONCTIONS                              */
/*ͼ*/

/****************************************************************************/
/* ProgrammingError                                                         */
/*--------------------------------------------------------------------------*/
/* Quitte l'application et affiche un message d'erreur indiquant l'endroit  */
/* dans le source o a eu lieu l'erreur                                     */
/****************************************************************************/

void ProgrammingError(int error_nb,char *file,int line)
{
  char *text;

  switch (GetLanguage())
    {
      case FRENCH : text   ="Sortie anormale du programme";
		    break;
      case GERMAN : text   ="Abnormales Programmende";
		    break;
      case ITALIAN: text   ="Programma terminato in modo non corretto";
		    break;
      case SPANISH: text   ="Terminacin anormal del programa";
		    break;
      case DUTCH  : text   ="Programma abnormaal beindigen";
		    break;
      case GREEK  : text   ="    ";
		    break;
      default     : text   ="Abnormal program termination";
    }

  CloseScreen();

  cerr << "\n\n" ;
  cerr << text ;
  if (error_nb!=0)
    cerr << " (" << error_nb << ")";
  cerr << " :\n" << file << " (" << line << ")\n\n";

  PlaySound(ERROR_SOUND);

  AbortProgram();
}


/****************************************************************************/
/* DisplayMemory                                                            */
/*--------------------------------------------------------------------------*/
/* Affichage de la mmoire disponible dans un coin de l'cran               */
/****************************************************************************/

// Autorise ou non l'affichage de la mmoire disponible

void ShowMemory()
{
  s_memory_display=TRUE;
}

void HideMemory()
{
  if (s_memory_display)
    {
      s_memory_display=FALSE;
      // Effacement de la mmoire prcdemment affiche
      JPRefreshAll();
    }
}

void DisplayMemory()
{
  char *string_ptr;
  char attribute;
  int screen_width;

  #ifdef __TCPLUSPLUS__

  char string[1+LONG_MAX_LENGTH+1];

  #else

  char string[1+LONG_MAX_LENGTH+1+LONG_MAX_LENGTH+1];

  #endif

  if (!s_memory_display)
    return;


  string_ptr=&(string[0]);
  attribute=(LIGHTRED<<4)+(unsigned)WHITE;

  #ifdef __TCPLUSPLUS__

  sprintf(string," %li",coreleft());

  #else

  sprintf(string," %li/%li",_go32_dpmi_remaining_physical_memory(),
			   _go32_dpmi_remaining_virtual_memory());

  #endif

  string_ptr=&(string[0]);
  attribute=(LIGHTRED<<4)+(unsigned)WHITE;
  screen_width=GetScreenWidth();

  #ifdef __TCPLUSPLUS__

  asm {
	push   ds
	lds    si,string_ptr
	mov    ax,0xB800
	mov    es,ax
	mov    di,0

	mov    ah,attribute
      }

  loop:

  asm {
	mov    al,ds:[si]
	cmp    al,0
	jz     fin
	inc    si
	mov    es:[di],ax
	add    di,2
	jmp    loop

      }

  fin:

  asm {
	mov    bx,di
	shr    bx,1
	mov    cx,screen_width
	sub    cx,bx
	mov    al,0x20
    rep stosw
	pop    ds
      }

  #else

  asm ("
	pushw  %%es
	movw   %0,%%es         # _dos_ds
	movl   $0xB8000,%%edi
	movl   %1,%%esi        # string_ptr

	movb   %2,%%ah         # attribute

  0:

	movb   %%ds:(%%esi),%%al
	cmpb   $0,%%al
	jz     1f
	incl   %%esi
	movw   %%ax,%%es:(%%edi)
	incl   %%edi
	incl   %%edi
	jmp    0b

  1:
	movl   %%edi,%%ebx
	subl   $0xB8000,%%ebx
	shrl   $1,%%ebx
	movl   %3,%%ecx
	subl   %%ebx,%%ecx
	movb   $0x20,%%al
    rep;stosw

	popw   %%es
       "
       :
       : "m" (_dos_ds),
	 "m" (string_ptr),
	 "m" (attribute),
	 "m" (screen_width)
       : "%esi","%edi","%ax");

  #endif

}


#endif
