/****************************************************************************/
/* SOUND                                                                    */
/*--------------------------------------------------------------------------*/
/* Sound routines	                                                    */
/*--------------------------------------------------------------------------*/
/* Author      : DELPRAT Jean-Pierre                                        */
/* Created on  : 10-Jan-95                                                  */
/****************************************************************************/

#include <dos.h>

#include "Const.h"

#include "Sound.h"

static char *s_sound_definition[]=
{ "\x14\x0A\x0A\x0A",                    // ERROR_SOUND
  "\x04\x0A",                            // BIP1
  "\x02\x0A\x04\x0A\x08\x0A\x10\x0A",    // SOUND_UP1
  "\x09\x02\x0A\x02\x0B\x02\x0C\x02" \
  "\x0D\x02\x0F\x02\x10\x02\x11\x02" \
  "\x12\x02\x13\x02"\
  "\x09\x02\x0A\x02\x0B\x02\x0C\x02" \
  "\x0D\x02\x0F\x02\x10\x02\x11\x02" \
  "\x12\x02\x13\x02"\
  "\x09\x02\x0A\x02\x0B\x02\x0C\x02" \
  "\x0D\x02\x0F\x02\x10\x02\x11\x02" \
  "\x12\x02\x13\x02"\
  "\x09\x02\x0A\x02\x0B\x02\x0C\x02" \
  "\x0D\x02\x0F\x02\x10\x02\x11\x02" \
  "\x12\x02\x13\x02"\
  "\x09\x02\x0A\x02\x0B\x02\x0C\x02" \
  "\x0D\x02\x0F\x02\x10\x02\x11\x02" \
  "\x12\x02\x13\x02"                     // ALARM1
};

/****************************************************************************/
/* PlaySound                                                                */
/*--------------------------------------------------------------------------*/
/* Plays a sound, which is selected with the argument `sound_type'          */
/****************************************************************************/

void PlaySound(TSound sound_type)
{
  char *ptr;
  int freq,duration;

  if (sound_type==NO_SOUND)
    return;

  ptr=s_sound_definition[sound_type];

  while ((*ptr)!=0)
  {
    freq=(*ptr++);
    duration=(*ptr);
    if (duration!=0)
      ptr++;

    sound(freq*100);
    delay(duration*10);
  }
  nosound();
}



