/****************************************************************************/
/* TCHKBOX                                                                  */
/*--------------------------------------------------------------------------*/
/* Objet TCheckBox (Case  cocher)                                          */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 10/01/95                                                    */
/****************************************************************************/

#include <conio.h>
#include <stdlib.h>

#include "Const.h"

#include "JPAppli.h"

#include "Callback.h"
#include "Mouse.h"
#include "Screen.h"
#include "SpChars.h"
#include "Strings.h"

#include "TWindow.h"
#include "TChkBox.h"

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************/
/* Constructeur */
/* ------------ */
/****************************************************************************/
/* parent           : Objet auquel appartient l'objet                       */
/* rel_x, rel_y  : Coordonnes de la case  cocher p/r au groupe            */
/* width         : Largeur de la case  cocher                              */
/* caption       : Lgende de la case  cocher (hot-key prcde de ~)      */
/* enabled       : ENABLED si la case est activable (DISABLED sinon)        */
/* checked       : CHECKED si la case est coche (NOT_CHECKED sinon)        */
/****************************************************************************/

TCheckBox::TCheckBox(PObject parent,
		     int rel_x,int rel_y,
		     int width,char *caption,
		     boolean checked,
                     boolean enabled)
	  :TObject(parent,
		   OBJ_CHECK_BOX,
		   rel_x,rel_y,
		   width,1,
		   (parent==NULL)?((unsigned)WHITE):parent->m_get_background(),
		   caption,
		   enabled,
		   TRUE,  // FOCUS_DEPENDING_ASPECT
		   TRUE,  // CAN_BE_ENABLED
		   TRUE)  // SIMPLE
{
  // CheckBox coche ou non

  f_checked=checked;

  // Callbacks

  InitCallback(f_checked_action,f_checked_argument);
  InitCallback(f_unchecked_action,f_unchecked_argument);
}

/***************/
/* Destructeur */
/* ----------- */
/***************/

TCheckBox::~TCheckBox()
{
  // Destruction des variables dynamiques

  DestroyCallback(f_unchecked_action,f_unchecked_argument);
  DestroyCallback(f_checked_action,f_checked_argument);
}

/****************************************/
/* m_check/m_uncheck : Coche ou dcoche */
/* -----------------   la case  cocher */
/****************************************/

void TCheckBox::m_check()
{
  m_take_check();
}

void TCheckBox::m_uncheck()
{
  m_lose_check();
}

/***********************************************************/
/* m_set_checked_callback : Dfinition du callback associ */
/* ----------------------   au cochage de la case  cocher */
/***********************************************************/

void TCheckBox::m_set_checked_callback(void (*checked_action)(PObject,char *),
				       char *checked_argument)
{
  SetCallback(f_checked_action,f_checked_argument,
              checked_action,checked_argument);
}

/***************************************************************/
/* m_set_unchecked_callback : Dfinition du callback associ   */
/* ------------------------   au dcochage de la case  cocher */
/***************************************************************/

void TCheckBox::m_set_unchecked_callback(void (*unchecked_action)(PObject,char *),
					  char *unchecked_argument)
{
  SetCallback(f_unchecked_action,f_unchecked_argument,
              unchecked_action,unchecked_argument);
}

/*ͻ*/
/*                           METHODES PROTEGEES                           */
/*ͼ*/

/****************************************/
/* m_take_check : Appele quand la case */
/* ------------   devient coche        */
/****************************************/

void TCheckBox::m_take_check()
{
  if (!f_checked)
    {
      f_checked=TRUE;
      m_display();

      CallCallback(this,f_checked_action,f_checked_argument);
    }
}

/****************************************/
/* m_lose_check : Appele quand la case */
/* ------------   perd sa coche         */
/****************************************/

void TCheckBox::m_lose_check()
{
  if (f_checked)
    {
      f_checked=FALSE;
      m_display();

      CallCallback(this,f_unchecked_action,f_unchecked_argument);
    }
}

/*ͻ*/
/*                            METHODES PRIVEES                            */
/*ͼ*/

/**********************************************************************/
/* m_display_focus_depending_part : Affichage de la partie de l'objet */
/* ------------------------------   dont l'aspect dpend du focus     */
/**********************************************************************/

void TCheckBox::m_display_focus_depending_part()
{
  m_display_caption();
}

/****************************************************************************/
/* m_display_caption                                                        */
/*--------------------------------------------------------------------------*/
/* Affichage de la lgende de l'objet                                       */
/****************************************************************************/

void TCheckBox::m_display_caption()
{
  int x,y;

  // Si l'objet n'est pas ouvert, rien  faire

  if (!f_open)
    return;

  // Rcupration des coordonnes de l'objet dans sa fentre

  x=m_get_x_in_window();
  y=m_get_y_in_window();

  // Affichage de la case  cocher

  f_window->m_gotoxy(x,y);

  if (!f_enabled)
    f_window->m_set_inactive_attr(f_background);
  else
    {
      if ((f_focused) && (f_window->m_is_active()))
	f_window->m_set_bright_attr(f_background);
      else
	f_window->m_set_normal_attr(f_background);
    }

  if (f_checked)
    f_window->m_puts(SPECIAL_STRING(SST_CHECKBOX_CHECKED));
  else
    f_window->m_puts(SPECIAL_STRING(SST_CHECKBOX_UNCHECKED));

  f_window->m_put_caption(f_caption,
			 f_enabled,
			 f_width-3,  // -3 pour la taille de la case
			 JUSTIFIED_LEFT);


}

/*********************************************************************/
/* m_left_button_pressed_event : L'utilisateur a cliqu dans l'objet */
/* ---------------------------   (l'objet tant activable).          */
/*                               Retourne TRUE si l'objet est        */
/*                               intress par cet vnement.        */
/*********************************************************************/

boolean TCheckBox::m_left_button_pressed_event(int /*x*/,int /*y*/)
{
  if (!f_focused)
    {
      if (!m_set_focus())
        return(FALSE);
    }

  if (f_checked)
    m_lose_check();
  else
    m_take_check();

  JPRefresh();

  WaitMouseLeftButtonRelease();
  return(TRUE);
}

/************************************************************************/
/* m_key_pressed_event : L'utilisateur a appuy sur une touche          */
/* -------------------   qui est propose  l'objet (qui est activable).*/
/*                       Retourne TRUE si l'objet est                   */
/*                       intress par cette touche.                    */
/************************************************************************/


boolean TCheckBox::m_key_pressed_event(TKey key)
{
  if ( (!f_focused) || (key.character!=SPACE))
    if (key.hot_character!=f_hot_key)
      return(FALSE);

  if (!f_focused)
    {
      if (!m_set_focus())
        return(FALSE);
    }

  if (f_checked)
    m_lose_check();
  else
    m_take_check();

  JPRefresh();

  return(TRUE);
}

