/****************************************************************************/
/* TSCRBAR                                                                  */
/*--------------------------------------------------------------------------*/
/* Objet TScrollBar (Barre de dplacement)                                  */
/****************************************************************************/

#ifndef _TSCRBAR_H_
#define _TSCRBAR_H_

#include "Types.h"

#include "TObject.h"


#define SCROLLBAR_FIRST_SCROLL_SPEED  150
#define SCROLLBAR_SCROLL_SPEED        70

typedef enum {
	       SB_HORIZONTAL,
	       SB_VERTICAL }
	     TSbOrientation;

class TScrollBar:public TObject
{
  /*-----------------*/
  /* Champs protgs */
  /*-----------------*/

  protected:

    // Orientation de l'ascenseur

    TSbOrientation
            f_orientation;

    // Valeur courante, et valeurs minimale et maximale de la ScrollBar

    long    f_value;
    long    f_min_value;
    long    f_max_value;


    // Pour viter des calculs :
    // -> diffrence entre f_max_value et f_min_value
    // -> taille de la cage d'ascenseur moins celle de l'ascenseur

    long    f_values_range;
    int     f_empty_size;

    // Incrment de f_value
    // -> pour un petit changement (clic sur une flche)
    // -> pour un grand changement (clic dans la cage,  ct de l'ascenseur)

    long    f_little_change;
    long    f_big_change;

    // Callback : Fonction appele quand la valeur de l'ascenseur change
    //            et son argument

    void (*f_value_changed_action)(PObject,char *);
    char *f_value_changed_argument;

  /*---------------*/
  /* Champs privs */
  /*---------------*/

  private:

    // Objet associ  l'ascenseur

    PObject f_related_object;

  /*--------------------*/
  /* Mthodes publiques */
  /*--------------------*/

  public:

    // Constructeur / Destructeur

		    TScrollBar(PObject parent,
                               TSbOrientation orientation,
			       int rel_x,int rel_y,
			       int length,
                               boolean enabled=TRUE);

    virtual         ~TScrollBar();

    // Mthodes d'accs

	    void    m_set_value(long value);
	    long    m_get_value() {return(f_value);};

	    void    m_set_min_max_values(long min_value,long max_value);
	    long    m_get_min_value() {return(f_min_value);};
	    long    m_get_max_value() {return(f_max_value);};

	    void    m_set_little_change(long little_change) { f_little_change=little_change;}
	    void    m_set_big_change(long big_change) { f_big_change   =big_change;}

    // Dfinition des callbacks

	    void    m_set_value_changed_callback(void (*value_changed_action)(PObject,char *),
						 char *value_changed_argument);

  /*--------------------*/
  /* Mthodes protges */
  /*--------------------*/

  protected:

    // Affichage

    virtual void    m_display();

    // Prise/perte du focus

    virtual void    m_take_focus();

    // Conversions valeur <-> position cran

	    int     m_value_to_position(long value);
	    long    m_position_to_value(int position);

  /*------------------*/
  /* Mthodes prives */
  /*------------------*/

  private:

    // Affichage

    virtual void    m_display_slider();
    virtual void    m_display_arrows();

    // Evnements

    virtual boolean m_left_button_pressed_event(int x,int y);
    virtual boolean m_arrow_pressed_event(int x,int y,int direction);
    virtual boolean m_shaft_pressed_event(int x,int y,int direction);

};

#endif