// ADDEVENT.H  Special case of getevent function - while mouse
//             button is pressed it returns event
//             Also it reacts at mouse clicks and key press
//             Scripts support is also proovided 

#ifndef __ADD_EVENT_H
#define __ADD_EVENT_H

#include "event.h"
#include <stdio.h>
#include <string.h>

#define MAX_MACROSES 100               // Macros recursion

enum { GO, RECORD, PLAY };             // Modes

extern int scriptMode;                 // GO, RECORD, PLAY
extern char* scriptFileName;           // name of script file
extern char* macrosFileName;           // name of active macros file
extern event e;                        // Last event in system
extern FILE* scriptPtr;                // File of script
extern FILE* macrosPtr;                // Macros file (usually, MACROS.MAC)

struct mac_status    // Structure keep some parameters for nested script-
    {                // macros processing.
    int mode;
    long pos;
    char* file;
    FILE* ptr;
    };

extern mac_status macros_stack[];    // stack for calling macros from another macros
extern int macros_used;                // No of mac_status(es) in stack

struct macros_context      // When key is pressed, run macros file from
    {                      // pos position
    int key;
    long pos;
    };

extern macros_context mac_table[];           // table for macros searching
					     // there are about 80 possible macroses
void init_macros(); // build mac_table using current macrosFileName

mac_status macros_pop();
void macros_push(mac_status);
void get_command(char* c);

void get_event(int mode = 0);   // User interface function

#endif __ADD_EVENT_H

