#include "blfsys.h"
#include "help.h"


BlockFile::BlockFile(char* h, rect coords, char* fName)
	: Block(coords, fName,  h, 3, FIXED, SHOW_BORDER, SHOW_BORDER,
	    0, 16, 16)
    {
    file_system = new FileSystem(rect(coords.origin.X + 2,
				      coords.origin.Y + 5,
				      coords.corner.X - 4,
				      coords.corner.Y - 2));
    edit = new EditLine(loc(coords.origin.X + 2, coords.origin.Y + 3),
			    coords.width() - 7, 80,
			    BUTTON_BORDER, 16, 1);

    edit->set_ret(RET_OK);
    file_system->set_ret(RET_OK);

    insert(edit, 1);
    add(file_system);

    assign(file_system, left_element, AC_LEFT);
    assign(file_system, right_element, AC_RIGHT);
    assign(file_system, up_element, AC_UP);
    assign(file_system, dn_element, AC_DOWN);
    assign(file_system, cancel_element, AC_CANCEL);
    assign(file_system, pg_up_element, AC_PG_UP);
    assign(file_system, pg_dn_element, AC_PG_DN);

    assign(file_system, edit, AC_SELECT);
    assign(0, file_system, AC_SELECT);
    }

////////////////////////////
void BlockFile::rearrange()
    {
    Block::rearrange();
    rect coord = textRect(w1->bound());

    edit->repose(rect(coord.origin.X + 2, coord.origin.Y + 3,
		      coord.corner.X - 5, coord.origin.Y + 5));

    file_system->repose(rect(coord.origin.X + 2,
			     coord.origin.Y + 5,
			     coord.corner.X - 4,
			     coord.corner.Y - 2));
    }
////////////////////////////
void BlockFile::exe(int act)
    {
    char reserv[MAXPATH];
    getcwd(reserv, MAXPATH);
    int res_disk = getdisk();

    Block::exe(act);

    setdisk(res_disk);
    chdir(reserv);
    }
/////////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
        return;
    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    BlockFile* s = new BlockFile("FILE SYSTEM");

    s->show();
    s->exe();

    delete s;
    close_KNOW_HOW();
    closegraph();
    }
*/