// BLK.CPP

#include "blk.h"

Block::Block(rect coord, char* fName, char* h, int s,
	    int res, BORDERS b_type, BORDERS hdr_b_type,
	    int pat, int hdr_pat, int elem_pat)
    : Bl(coord, fName, h, s, res, b_type, hdr_b_type,
	    pat, hdr_pat, elem_pat)
    {
    int x = screenXL(coord.corner.X - 2) - w1->get_shadow();
    int y_up = screenYT(coord.origin.Y) + w1->get_shadow();
    int y_pg_up = screenYT(coord.origin.Y + 1) + w1->get_shadow();
    int y_pg_dn = screenYT(coord.corner.Y - 3) - w1->get_shadow();
    int y_dn = screenYT(coord.corner.Y - 2) - w1->get_shadow();

    up_element = new Element(rect(x, y_up, x + 2 * pScreenSet->cell_width - 1,
                                  y_up + pScreenSet->cell_height),
                        UP_ELEMENT, BUTTON_BORDER, elem_pat, 1);
    pg_up_element = new Element(rect(x, y_pg_up,
	                 x + 2 * pScreenSet->cell_width - 1,
                         y_pg_up + pScreenSet->cell_height),
                         PG_UP_ELEMENT, BUTTON_BORDER, elem_pat, 1);
    pg_dn_element = new Element(rect(x, y_pg_dn,
	                 x + 2 * pScreenSet->cell_width - 1,
                         y_pg_dn + pScreenSet->cell_height),
                         PG_DN_ELEMENT, BUTTON_BORDER, elem_pat, 1);
    dn_element = new Element(rect(x, y_dn, x + 2 * pScreenSet->cell_width - 1,
                         y_dn + pScreenSet->cell_height),
                         DN_ELEMENT, BUTTON_BORDER, elem_pat, 1);

    left_element = new Element(rect(screenXL(coord.origin.X)
	        + w1->get_shadow(),
	    screenYT(coord.corner.Y - 1) - w1->get_shadow(),
	    screenXR(coord.origin.X) + 2 * pScreenSet->cell_width
	        + w1->get_shadow(),
            screenYT(coord.corner.Y) - w1->get_shadow()),
            LEFT_ELEMENT, BUTTON_BORDER, elem_pat, 1);
    right_element = new Element(rect(x, y_dn + pScreenSet->cell_height,
	    x + 2 * pScreenSet->cell_width - 1,
	    y_dn + 2 * pScreenSet->cell_height),
            RIGHT_ELEMENT, BUTTON_BORDER, elem_pat, 1);

    add(up_element);
    add(dn_element);
    add(pg_up_element);
    add(pg_dn_element);
    add(left_element);
    add(right_element);
    moveTo(1);
    }
//////////////////
void Block::rearrange()
    {
    Bl::rearrange();
    rect coord = textRect(w1->bound());
    w1->repose(coord);

    int x = screenXL(coord.corner.X - 2) - w1->get_shadow();
    int y_up = screenYT(coord.origin.Y) + w1->get_shadow();
    int y_pg_up = screenYT(coord.origin.Y + 1) + w1->get_shadow();
    int y_pg_dn = screenYT(coord.corner.Y - 3) - w1->get_shadow();
    int y_dn = screenYT(coord.corner.Y - 2) - w1->get_shadow();

	up_element->repose(rect(x, y_up, x + 2 * pScreenSet->cell_width - 1,
                                  y_up + pScreenSet->cell_height));
	pg_up_element->repose(rect(x, y_pg_up,
	                 x + 2 * pScreenSet->cell_width - 1,
                         y_pg_up + pScreenSet->cell_height));
	pg_dn_element->repose(rect(x, y_pg_dn,
	                 x + 2 * pScreenSet->cell_width - 1,
                         y_pg_dn + pScreenSet->cell_height));
	dn_element->repose(rect(x, y_dn, x + 2 * pScreenSet->cell_width - 1,
                         y_dn + pScreenSet->cell_height));

	left_element->repose(rect(screenXL(coord.origin.X)
	        + w1->get_shadow(),
	    screenYT(coord.corner.Y - 1) - w1->get_shadow(),
	    screenXR(coord.origin.X) + 2 * pScreenSet->cell_width
	        + w1->get_shadow(),
            screenYB(coord.corner.Y) - w1->get_shadow()));
        right_element->repose(rect(x, y_dn + pScreenSet->cell_height,
	    x + 2 * pScreenSet->cell_width - 1,
	    y_dn + 2 * pScreenSet->cell_height));

    }
////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
        return;
    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    Block b(rect(10, 10, 60, 20), "window.pcy", "Block", 6,
	    MOVE | RESIZE | SCROLL_VERT,
	    SHOW_BORDER, SHOW_BORDER,
	    16, 17, 16);

    b.show();
    b.exe();

    close_KNOW_HOW();
    closegraph();
    }
*/