#include "blkpanel.h"

BlockPanel::BlockPanel(rect coord, char* fName, char* h,
	       char* HOT,
	       int ITEMTYPE, int* ITEMLIST, loc ITEMDISTANCE,
	       rect STATUSPOS,
	       int STATUSTYPE, char** STATUSSTRINGS,
	       int* STATUSLIST, int res, int s,
	       BORDERS b_type, BORDERS hdr_b_type, int pat, int hdr_pat,
	       int elem_pat, int menu_pat)
    	: Block(coord, fName, "", s,
	       res, b_type, NO_BORDER, pat, hdr_pat, elem_pat)
    {
    menu = new IconMenu(rect(coord.origin.X + 3 + textX(s),
             coord.origin.Y + textY(s) + 1,
	     coord.corner.X - 3 - textX(s),
	     coord.corner.Y - 1 - textY(s)),
	     "", h, HOT, 1, 1,
	       ITEMTYPE, ITEMLIST, ITEMDISTANCE,
	       STATUSPOS, STATUSTYPE, STATUSSTRINGS,
	       STATUSLIST, FIXED, 0, b_type, hdr_b_type, menu_pat,
	       hdr_pat);

    menu->set_ret(1);

    insert(menu, 1);

    assign(menu, up_element, AC_UP);
    assign(menu, dn_element, AC_DOWN);
    assign(menu, cancel_element, AC_CANCEL);
    assign(menu, pg_up_element, AC_PG_UP);
    assign(menu, pg_dn_element, AC_PG_DN);
    assign(menu, left_element, AC_LEFT);
    assign(menu, right_element, AC_RIGHT);
    }
////////////////////////
void BlockPanel::rearrange()
    {
    Block::rearrange();
    rect coord = textRect(w1->bound());

    int sx = textX(w1->get_shadow());
    int sy = textY(w1->get_shadow());

    menu->repose(rect(coord.origin.X + 3 + sx, coord.origin.Y + 1 + sy,
		      coord.corner.X - 3 - sx,
		      coord.corner.Y - 1 - sy));
    }
////////////////////
void BlockPanel::hide()
    {
    menu->hide();
    w1->hide();
    }
///////////////////////////
/*
#include "hypview.h"
#include "help.h"
void main()
    {
    if(!init_KNOW_HOW())
        return;
    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    int LIST[] = { 1, 2, 3, 1, 2, 3, 3, 2, 1, 2, 0 };
    BlockPanel b(rect(10, 10, 60, 16), "window.pcy", "Icon Menu",
	       "1234567890", SMALL_ICON, LIST, loc(5, 5),
	       rect(0, 20, 79, 25), LARGE_ICON,
	       NULL, LIST,
	       MOVE | RESIZE | SCROLL_VERT | SCROLL_HORIZ, 6,
	       SHOW_BORDER, SHOW_BORDER, 11, 12, 13, 16);

    rect r_help(5, 5, 70, 25);
    help_object = new HypertextView(r_help, "help.hyp",
        "_help.pcy", MOVE | RESIZE | SCROLL_VERT | SCROLL_HORIZ,
	pScreenSet->sub_interval, SHOW_BORDER,
	25, "HELP", BLUE, YELLOW, 56);
    b.set_help_context("common  ");
    b.show_window();
    b.exe();
    b.hide();

    delete help_object;
    close_KNOW_HOW();
    closegraph();
    }
*/