#include "context.h"
#include "formline.h"

Context::Context(rect STATUSPOS, int STATUSTYPE, char** STATUSSTRINGS,
       int* STATUSLIST)
    {
    statusPos = STATUSPOS; statusType = STATUSTYPE;
    statusStrings = STATUSSTRINGS;
    statusList = STATUSLIST;
    }
///////////////////////////
void Context::showStatus(int pos, int pat)
    {
    switch(statusType)
	{
	case NO_STATUS: break;
	case STRING_STATUS:
	    if(statusStrings != NULL)
		{
		FormLine status_line(BUTTON_BORDER);
		status_line.outtextxy(statusPos.origin,
		     statusPos.corner.X, statusStrings[pos - 1], pat);
		}
	    break;
	case MEDIUM_ICON_STATUS:
	case SMALL_ICON_STATUS:
	case LARGE_ICON_STATUS:
	    if(statusList != NULL)
		{
		Icon icon(statusPos.origin, statusList[pos - 1], statusType,
		    BUTTON_BORDER);
		icon.show();
		}
	    break;
	case PCX_STATUS:
	    if(statusStrings != NULL)
		{
		pcx_file_scr(statusStrings[pos - 1],
			     screenLocLT(statusPos.origin));
		}
	    break;
	}

    }
//////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
        return;
    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    int STATUS[] = { 1, 0 };
    Context c(rect(10, 12, 70, 20),
	       LARGE_ICON_STATUS, NULL,
	       STATUS);

    c.showStatus(1, SHOW_BORDER, 19);

    close_KNOW_HOW();
    closegraph();
    }
*/