#include "element.h"
#include "patterns.h"
#include "khbgi.h"

void Element::show()
    {
    setcolor(pColorSet->colors.ATTR_COLOR);
    setlinestyle(SOLID_LINE, 1, 1);
    rect r = tog ? rectangle : screenRect(rectangle);
    r.corner -= loc(2, 2);
    int x = (r.origin.X + r.corner.X) / 2;
    int y = (r.origin.Y + r.corner.Y) / 2;
    bar(r, (int)pColorSet->colors.BAK_COLOR,
        (int)pColorSet->colors.FILL_COLOR, (uchar*)::pattern[pattern]);

    switch(type)
	{
        case NO_ELEMENT:
            break;
        case BLACK_ELEMENT: case BLUE_ELEMENT: case GREEN_ELEMENT:
	case CYAN_ELEMENT:case RED_ELEMENT: case MAGENTA_ELEMENT:
	case BROWN_ELEMENT: case LIGHTGRAY_ELEMENT: case DARKGRAY_ELEMENT:
	case LIGHTBLUE_ELEMENT:	case LIGHTGREEN_ELEMENT:
	case LIGHTCYAN_ELEMENT: case LIGHTRED_ELEMENT:
        case LIGHTMAGENTA_ELEMENT: case YELLOW_ELEMENT:
	case WHITE_ELEMENT:
	    setfillstyle(SOLID_FILL, type - BLACK_ELEMENT);
	    bar(rect(r.origin + 3, r.corner - 3));
	    break;
	case HOME_ELEMENT:
	    line(x, y,
		 r.corner.X - area[border_type].corner.X, y);
	    line(x, y, r.corner.X - area[border_type].corner.X,
		 r.origin.Y + area[border_type].origin.Y);
	    line(x, y, r.corner.X - area[border_type].corner.X,
		 r.corner.Y - area[border_type].corner.Y);
	    line(x, r.origin.Y + area[border_type].origin.Y,
		 x, r.corner.Y - area[border_type].corner.Y);
	    break;
	case END_ELEMENT:
	    line(r.origin.X + area[border_type].origin.X, y,
		 x, y);
	    line(x, y, r.origin.X + area[border_type].origin.X,
		 r.origin.Y + area[border_type].origin.Y);
	    line(x, y, r.origin.X + area[border_type].origin.X,
		 r.corner.Y - area[border_type].corner.Y);
	    line(x, r.origin.Y + area[border_type].origin.Y,
		 x, r.corner.Y - area[border_type].corner.Y);
	    break;

	case LEFT_ELEMENT:
	    line(r.origin.X + area[border_type].origin.X, y,
		 r.corner.X - area[border_type].corner.X, y);
	    line(r.origin.X + area[border_type].origin.X, y,
		 x, r.origin.Y + area[border_type].origin.Y);
	    line(r.origin.X + area[border_type].origin.X, y,
		 x, r.corner.Y - area[border_type].corner.Y);
	    break;
	case RIGHT_ELEMENT:
	    line(r.origin.X + area[border_type].origin.X, y,
		 r.corner.X - area[border_type].corner.X, y);
	    line(r.corner.X - area[border_type].corner.X, y,
		 x, r.corner.Y - area[border_type].corner.Y);
	    line(r.corner.X - area[border_type].corner.X, y,
		 x, r.origin.Y + area[border_type].origin.Y);
	    break;
	case MOVE_ELEMENT:
	    line(r.origin.X + area[border_type].origin.X, y,
		 r.corner.X - area[border_type].corner.X, y);
	    line(r.origin.X + area[border_type].origin.X, y,
		 x, r.origin.Y + area[border_type].origin.Y);
	    line(r.corner.X - area[border_type].corner.X, y,
		 x, r.corner.Y - area[border_type].corner.Y);
	    break;
	case RESIZE_ELEMENT:
	    line(r.origin.X + area[border_type].origin.X,
		 r.origin.Y + area[border_type].origin.Y,
		 r.corner.X - area[border_type].corner.X,
		 r.corner.Y - area[border_type].corner.Y);
	     line(r.corner.X - area[border_type].corner.X,
		  r.corner.Y - area[border_type].corner.Y,
		  x, r.corner.Y - area[border_type].corner.Y);
	     line(r.corner.X - area[border_type].corner.X,
		  r.corner.Y - area[border_type].corner.Y,
		  r.corner.X - area[border_type].corner.X, y);
	     break;
	case UP_ELEMENT:
	    line(x, r.origin.Y + area[border_type].origin.Y,
		 x, r.corner.Y - area[border_type].corner.Y);
	    line(r.origin.X + area[border_type].origin.X, y,
		 x, r.origin.Y + area[border_type].origin.Y);
	    line(r.corner.X - area[border_type].corner.X, y,
		 x, r.origin.Y + area[border_type].origin.Y);
	    break;
	case DN_ELEMENT:
	    line(x, r.origin.Y + area[border_type].origin.Y,
		 x, r.corner.Y - area[border_type].corner.Y);
	    line(r.corner.X - area[border_type].corner.X, y,
		 x, r.corner.Y - area[border_type].corner.Y);
	    line(r.origin.X + area[border_type].origin.X, y,
		 x, r.corner.Y - area[border_type].corner.Y);
	    break;
	case PG_UP_ELEMENT:
	    line(x, r.origin.Y + area[border_type].origin.Y,
		 x, r.corner.Y - area[border_type].corner.Y);
	    line(r.origin.X + area[border_type].origin.X, y,
		 x, r.origin.Y + area[border_type].origin.Y);
	    line(r.corner.X - area[border_type].corner.X, y,
		 x, r.origin.Y + area[border_type].origin.Y);
	    line(r.origin.X + area[border_type].origin.X,
		r.corner.Y - area[border_type].corner.Y, x, y);
	    line(x, y,
		 r.corner.X - area[border_type].corner.X,
		 r.corner.Y - area[border_type].corner.Y);
	    break;
	case PG_DN_ELEMENT:
	    line(x, r.origin.Y + area[border_type].origin.Y,
		 x, r.corner.Y - area[border_type].corner.Y);
	    line(r.corner.X - area[border_type].corner.X, y,
		 x, r.corner.Y - area[border_type].corner.Y);
	    line(r.origin.X + area[border_type].origin.X, y,
		 x, r.corner.Y - area[border_type].corner.Y);
	    line(r.origin.X + area[border_type].origin.X,
		 r.origin.Y + area[border_type].origin.Y,
		 x, y);
	    line(x, y,
		 r.corner.X - area[border_type].corner.X,
		 r.origin.Y + area[border_type].origin.Y);
	    break;
	case CANCEL_ELEMENT:
	    line(r.origin.X, r.origin.Y, r.corner.X, r.corner.Y);
	    line(r.corner.X, r.origin.Y, r.origin.X, r.corner.Y);
	    break;
	case OK_ELEMENT:
	    circle(x, y,
		(r.width() - area[border_type].origin.X
		    - area[border_type].corner.X) / 3);
	    break;
        default:
            break;
	}
    Frame::show();
    }
//////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
        return;
    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    Element e(rect(1, 1, 15, 6), OK_ELEMENT, BUTTON_BORDER);
    e.show();
    e.exe();

    close_KNOW_HOW();
    closegraph();
    }
*/