/*  KNOW-HOW.DRAW 2.1 - The PCX images Editor.
    (C) Stepan S. Vartanov, 1993.
    Contacts:

        ( D E A L E R S   I N V I T E D )

    ATTENTION !!! This product needs the KNOW-HOW 4.x interface library
                  and (desirable) KNOW-HOW 1.x PRINT MANAGER SYSTEM
*/

#ifndef __KH_DRAW_H_
#define __KH_DRAW_H_
#include "b&w.h"
#include "board.h"
#include "help.h"        // Help system
#include "prn_form.h"    // Printer setup
#include "appkit.h"
#include "blkwrite.h"
#include "microsc.h"
#include "bldraw.h"
#include "icons.h"
#include "blkmenu.h"
#include "bllmenu.h"
#include "blkpanel.h"
#include "icon.h"
#include "editl.h"
#include "print.h"
#include "blfsys.h"
#include "tools.h"
#include "elemmenu.h"
#include "col_sbar.h"

enum { AC_FILE_MENU = 101, AC_EDIT_MENU, // items of the line menu
       AC_EFFECTS_MENU, AC_TEXT_MENU, AC_METHOD_MENU, AC_SCRIPT_MENU,
       AC_PRINT_MENU,

       AC_NEW, AC_OPEN, AC_SAVE, AC_SAVE_AS_BW, AC_ABOUT,   // go here from "file_menu"

       AC_FILL_PANEL, // go here from "fill_prompt"

       AC_TOOL_UNDO, AC_FILTER, AC_DITHER,        // go here from "effects_menu"
       AC_TEXT, AC_SCROLL, AC_LOCAL_UNDO,

       AC_FILTERS, AC_DITHERS, AC_GRADS, AC_ERROR_PROP,

       AC_EDIT_CUT, AC_COPY, AC_COPY_FROM,  // go here from edit_menu
       AC_COPY_TO, AC_COPY_TO_BW, AC_PASTE, AC_ZOOM, AC_TRANS, AC_PREVIEW,

       AC_TEXT_SIZE,    // go here from "text_menu"
       AC_TEXT_DIR,
       AC_TEXT_FONT,

       AC_TEXT_EDIT,

       AC_TOOLS, AC_TOOLS_1, AC_COLORS,         // go here from "methods menu"
       AC_BAKS, AC_FILL_PROMPT, AC_DRAW,

       AC_SCRIPT_PLAY, AC_SCRIPT_RECORD, // go here from "script_menu"
       AC_SCRIPT_END, AC_MACROS_KEEP, AC_EDITOR, AC_RESERVED,

       AC_LINE_WIDTH, AC_MICROSCOPE,           // go here from "tool_panel"
       AC_SCISSORS, AC_ERASER, AC_COLOR_ERASER,
       AC_FILL, AC_RECTANGLE, AC_CIRCLE, AC_LINE,
       AC_PEN,

       AC_LINE_1, AC_LINE_6 = AC_LINE_1 + 5,  // go here from "lines_panel"

       AC_BLACK, AC_WHITE = AC_BLACK + 15,    // go here from "colors" and
       AC_BLACK1, AC_WHITE1 = AC_BLACK1 + 15, // "background" panels

       AC_FILL1, AC_FILL48 = AC_FILL1 + 48,   // go here from "fill_panel"

       AC_MICROSCOPE_2,    // go here from microscope
       AC_ASK_EXIT,

       AC_PRINT,    // go here from "form" (print setup)
       AC_SIZE1, AC_SIZE2 = AC_SIZE1 + 15, // font deformation
       AC_HORIZ, AC_VERT,

       AC_FILTER1, AC_FILTER2, AC_FILTER3, AC_FILTER4, AC_FILTER5,
       AC_FILTER6, AC_FILTER7, AC_FILTER8, AC_FILTER9, AC_FILTER10,
       AC_FILTER11, AC_FILTER12, AC_FILTER13, AC_FILTER14,

       AC_DITHER1, AC_DITHER2, AC_DITHER3, AC_DITHER4, AC_DITHER5, AC_DITHER6,
       AC_DITHER7, AC_DITHER8, AC_DITHER9, AC_DITHER10, AC_DITHER11,
       AC_DITHER12, AC_DITHER13, AC_DITHER14,

       AC_NO_GRAD, AC_HORIZ_GRAD, AC_VERT_GRAD,

       AC_NO_ERROR_PROP, AC_ERROR_PROP_ON,

       AC_MOVE_APPL, AC_RESIZE_APPL,

       AC_BUFFER_SIZE, AC_BUFFER_SIZE7 = AC_BUFFER_SIZE + 7,
       AC_FILE
    };

class KH_Draw : public ApplicationKit
    {
    protected:
        int DATA_ATTR,   DATA_BAK,         DATA_FILL, DATA_FILE, // flags
            DATA_LINE,   DATA_EDIT,        DATA_SIZE,
            DATA_TOOLS,  DATA_DIR,         DATA_ZOOM, DATA_TRANS,
            DATA_PRINT,  DATA_FILTER,      DATA_GRAD, DATA_ERROR_PROP,
            DATA_DITHER, DATA_BUFFER_SIZE, DATA_X,    DATA_Y,
            DATA_PREVIEW;

        char* fontName;

        Window* w1;
        BlockMenu* file_menu;
        BlockFile* file_sys;
        BlockMenu* methods_menu;
        BlockDraw* draw;
        BlockLineMenu* menu;
        IconMenu* tool_panel;
        BlockPanel* lines_panel;
        IconMenu* resize_panel;
        ColorScrollBar* colors_panel;
        ColorScrollBar* colors2_panel;
        BlockPanel* fill_panel;
//      IconMenu* fill_prompt;
        Element* fill_prompt;
        BlockMenu* edit_menu;
        BlockMenu* text_menu;
        BlockMenu* font_menu;
        BlockMenu* size_menu;
        Microscope* micro;
        BlockMenu* script_menu;
        PrintManager* print;
        GrafBuffer* buffer;
        Form* form;
        BlockMenu* filters;
        BlockMenu* dithers;
        BlockMenu* buffer_size;
        BlockMenu* dir_menu;
        BlockMenu* grads;
        BlockMenu* error_prop;
        IconMenu* tool_panel1;
        BlockMenu* effects_menu;
        BlockWrite* editor;

    public:
        KH_Draw(char* fileName, char* buf_name, int obj_number = 0,
                int step = 1);
        virtual ~KH_Draw();
        virtual void show();
        virtual void rearrange();
        virtual int application(int n);
        void prepare_files();
        void askSave();
        virtual int active() { return w1->active(); }
    friend int application(int num_in_switch, KH_Draw* kit);
    friend class Draw;
    };

#endif __KH_DRAW_H_