#include "kh_table.h"

KH_TableView::KH_TableView(int w, int h, int col, int* wid, int* colNum)
    {
    yStart = 0;
    yPos = 0;
    xStart = 0;
    xPos = 0;
    xCurs = 0;
    yCurs = 0;
    xScreen = w;
    yScreen = h;
    nColumns = col == -1 ? getColumnNumber() : col;
    iColWidth = wid;       // Array of widths of col.
    colNumbers = colNum;
    }
//////////////////////////////
int KH_TableView::Left()
    {
    if(xPos > 0)
	{
	xCurs--;
	xPos -= iColWidth[colNumbers[xCurs]];
	return 0;
	}
    if(xPos == 0 && xStart)
	{
	xCurs--;
	xStart -= iColWidth[colNumbers[xCurs]];
	return 1;
	}
    return 0;
    }
//////////////////////////////////
int KH_TableView::Right()
    {
    if(xCurs < nColumns - 1)
	{
	if(xPos + iColWidth[colNumbers[xCurs]]
	    >= xScreen - iColWidth[colNumbers[xCurs + 1]])
	    {
	    xStart += xPos + iColWidth[colNumbers[xCurs]];
	    xCurs++;
	    xPos = 0;
	    return 1;
	    }
	else
	    {
	    xPos += iColWidth[colNumbers[xCurs]];
	    xCurs++;
	    return 0;
	    }
	}
    return 0;
    }
///////////////////////////////////
int KH_TableView::Up()
    {
    if(yPos > 0)
	{
	yCurs--;
	yPos--;
	return 0;
	}
    if(yPos == 0 && yStart)
	{
	yCurs--;
	yStart--;
	return 1;
	}
    return 0;
    }
////////////////////////////////
int KH_TableView::Down()
    {
    if(yCurs < RecordNumber() - 1 || RecordNumber() == -1)
	{
	if(yPos + 3 >= yScreen)
	    {
	    yStart += yPos;
	    yPos = 0;
	    yCurs++;
	    return 1;
	    }
	else
	    {
	    yPos++;
	    yCurs++;
	    return 0;
	    }
	}
    return 0;
    }
////////////////////////////////
void KH_TableView::Home()
    {
    xStart = xPos = xCurs = 0;
    }
////////////////////////////////
void KH_TableView::End()
    {
    xStart = 0;
    for(int j = 0; j < nColumns - 1; j++)
	xStart += iColWidth[colNumbers[j]];
    xCurs = nColumns - 1;
    xPos = 0;
    }
////////////////////////////////
void KH_TableView::PgUp()
    {
    if(yStart > yScreen)
	yStart -= yScreen - 1;
    else
	yStart = yPos = 0;
    yCurs = yStart;
    }
////////////////////////////////
void KH_TableView::PgDown()
    {
    if(RecordNumber() - 1 - yCurs > yScreen || RecordNumber() == -1)
	yStart += yScreen - 1;
    else
	{
	yStart = RecordNumber() - 1;
	yPos = 0;
	}
    yCurs = yStart;
    }
////////////////////////////////
void KH_TableView::CtrlPgUp()
    {
    yStart = yPos = yCurs = 0;
    }
////////////////////////////////
void KH_TableView::CtrlPgDown()
    {
    yStart = yCurs = RecordNumber() - 1;
    yPos = 0;
    }
////////////////////////////////
void KH_TableView::PgLeft()
    {
    for(int i = 0, x = 0; x < xStart; i++)
	x += iColWidth[colNumbers[i]];
    for(i = i - 1, x = xStart;
	x > xStart - xScreen && i >= 0; i--)
	x -= iColWidth[colNumbers[i]];
    xCurs = i + 1;
    xPos = 0;
    xStart = x;
    }
////////////////////////////////
void KH_TableView::PgRight()
    {
    for(int i = 0, x = 0;
	x < xScreen + xPos && i < nColumns - 1;	i++)
	x += iColWidth[colNumbers[i]];
    xCurs = i;
    xPos = 0;
    xStart = x;
    }
////////////////////////////////
void KH_TableView::moveToCell(loc ms)
    {
    for(int i = 0, x = 0; i < nColumns && x < xStart + ms.X; )
	{
	x += iColWidth[colNumbers[i]];
	i++;
	}
    xPos = x - xStart;
    xCurs = i;
    Left();

    if(xPos && xPos + iColWidth[colNumbers[xCurs]] > xScreen)
	{
	xCurs--;
	xPos -= iColWidth[colNumbers[xCurs]];
	}

    if(ms.Y <= 0)
	return;

    if(ms.Y + yStart > RecordNumber())
	{
	yCurs = RecordNumber() - 1;
	yPos = yCurs - yStart;
	}
    else
	{
	yPos = ms.Y + 1 > yScreen ? yPos : ms.Y - 1;
	yCurs = yPos + yStart;
	}

    }
//////////////////////////////
void KH_TableView::Rotate()
    {
    int col = colNumbers[xCurs];
    for(int i = xCurs; i < nColumns - 1; i++)
	colNumbers[i] = colNumbers[i + 1];
    colNumbers[nColumns - 1] = col;
    }

