#ifndef __KH_STRING_TABLE_H_
#define __KH_STRING_TABLE_H_

#include <alloc.h>
#include <string.h>


/*    KH_STRTABLE provides set of data and operations on the (char**)
      - group of strings.
*/

struct KH_STRTABLE
    {
    int used;                               // Total number of strings
    int total;                              // Allocated
    char** strings;                         // Strings

    KH_STRTABLE(int n, char** str = NULL);  // Builds string array. If str
					    //   is NULL, sets all strings to
					    //   '\0'.
    ~KH_STRTABLE();

    int add(char* str);                     // Append to the end of list

    char* operator [](int n) { return strings[n]; }
    };

#endif __KH_STRING_TABLE_H_