#ifndef __VECTOR_H_
#define __VECTOR_H_

/*  VECTOR 1.0 - The vector images Editor.
    (C) Stepan S. Vartanov, 1994.
    Contacts:


        ( D E A L E R S   I N V I T E D )

    ATTENTION !!! This product needs the KNOW-HOW 4.x interface library
                  and (desirable) KNOW-HOW 1.x PRINT MANAGER SYSTEM
*/
#include "khoopic.h"     // khoopic.h or blkoopic.h could be used
#include "ask_hot.h"  // Button which may be hidden and macros append
                      // function
#include "icon.h"     // About cartoon
#include "board.h"    // About system


#include "prn_form.h"    // Printer setup
#include "bufsetup.h"
#include "appkit.h"      // ApplicationKit
#include "write.h"       // write.h or blkwrite.h could be used
#include "print.h"       // Print manager

#include "b&w.h"         // PCX color <-> B&W convertor
#include "help.h"        // Help system

#include "bllmenu.h"     // Line (main) menu
#include "blkmenu.h"

#include "blfsys.h"      // File system
#include "window.h"

enum { AC_FILE_MENU = 101, // items of the line menu
       AC_BUFFER_MENU, AC_SCRIPT_MENU, AC_PRINT_MENU,

       AC_NEW, AC_OPEN, AC_SAVE, AC_SAVE_AS_PCX,  // go here from "file_menu"
       AC_SAVE_AS_PCX_BW, AC_ABOUT,

       AC_BUFFER,   // Go here from Options

       AC_SCRIPT_PLAY, AC_SCRIPT_RECORD, // go here from "script_menu"
       AC_SCRIPT_END, AC_MACROS_KEEP,

       AC_PROGRAM_EDIT,  AC_PROGRAM_RUN, // Program editor and interpreter
       AC_PROGRAM_SAVE_AND_RUN,

       AC_ASK_EXIT, // Before exit ask Y/N

       AC_PRINT,    // go here from "form" (print setup)

       AC_MOVE_APPL, AC_RESIZE_APPL,  // If you want to move / resize base

       AC_FILE // After File system was executed
    };

class Vector : public ApplicationKit
    {
    protected:
        int DATA_FILE; // The way we come to the File system (f.e. from Open
                       // or Save).

        Window* w1;                   // System base window
        BlockLineMenu* menu;          // Main menu
        BlockMenu* file_menu;         // New, Open, Save...
        BlockFile* file_sys;          // List of files
        BlockMenu* script_menu;       // Script Manager
        PrintManager* print;          // Print Manager
        GrafBuffer* buffer;           // Buffer of Print and PCX managers
        Form* form;                   // Printer setup
        BufferSetup* setup;           // Buffer setup form
        Write* editor;                // Text (program) editor
        KH_OOPic* vector;             // Picture draw window.
	Button* OK_button;

    public:
        Vector(char* fileName,        // File for swapping
               char* buf_name,        // Name of Print/PCX tmp. swap file
               int obj_number = 0,    // Number in upper level container
                int step = 1);        // Step in objects numeration.
        virtual ~Vector();            // Destructor
        void reload();
        virtual void show();          // Show some objects
//      virtual void rearrange();     // Used if resize facility is available
        virtual int application(int n);  // User-defined functions
        void prepare_files();         // Before file_system
        virtual int active() { return w1->active(); }  // Is visible?
        void to_buffer();

    friend class KH_OOPic;
    };

#endif __VECTOR_H_