#include "window.h"
#include "global.h"
#include "pcx.h"


Window::Window(rect coordinates, char* fName, char* h, int s,
               BORDERS b_type, BORDERS hdr_b_type,
	       int res, int pat, int hdr_pat)
	: Border(coordinates, h, b_type, hdr_b_type, s, hdr_pat)
    {
    fileName = fName ? strdup(fName) : strdup("");
    resize_status = fName ? res : FIXED;
    once = 0;
    pattern = pat;
    }
////////////////////
void Window::hilite()
    {
    mouseHideCursor();
    Border::hilite();
    mouseShowCursor();
    }
//////////////////////
void Window::unhilite()
    {
    mouseHideCursor();
    Border::unhilite();
    mouseShowCursor();
    }
//////////////////////
void Window::repose(rect new_pos)
    {
    rectangle = new_pos;
    Header::len =
        screenXL(new_pos.corner.X -
	     new_pos.origin.X - 1)
	     - area[border_type].origin.X -
	     area[border_type].corner.X - 2 * shadow;
    }
////////////////////////
void Window::exe(int act)
    {
    rect work = screenRect(rectangle);
    switch(act)
	{
	case AC_MOVE:
            global_i[0] = AC_REDRAW;
            global_i[1] = AC_MOVE;
	    return;
	case AC_RESIZE:
            global_i[0] = AC_REDRAW;
            global_i[1] = AC_RESIZE;
            return;
	case 0:
        default:
	    e.what = KEYEVENT;
	    e.key = 0;
            global_i[0] = action_type;
            global_num = 1;
            return;
	}
    }
/////////////////////////
void Window::show()
    {
    mouseHideCursor();
    settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
    clrscr();
    once = 1;
    mouseShowCursor();
    }
///////////////////
void Window::show_window()
    {
    mouseHideCursor();
    if(*fileName != '\0')
        pcx_scr_file(screenRect(rectangle), fileName, 0);
    show();
    mouseShowCursor();
    }
///////////////////
void Window::hide()
    {
    mouseHideCursor();
    if(!(ret & RET_STACKED) && *fileName != '\0')
        pcx_file_scr(fileName, screenLocLT(rectangle.origin));
    once = 0;
    mouseShowCursor();
    }
//////////////////
rect Window::user_screen()
    {
    return rect(screenXL(rectangle.origin.X)
			      + area[border_type].origin.X + shadow,

		screenYT(rectangle.origin.Y)
		   + !(header == NULL) * (pScreenSet->standart_height + 2 +
		   area[hdr_b_type].origin.Y + area[hdr_b_type].corner.Y)
			      + area[border_type].origin.Y + shadow,

		screenXR(rectangle.corner.X)
			      - area[border_type].corner.X - shadow,

		screenYB(rectangle.corner.Y)
			      - area[border_type].corner.Y - shadow);
    }
/////////////////////////////
void Window::clrscr()
    {
    rect temp = user_screen();
    mouseHideCursor();
    if(pattern == 0)
        {
	setfillstyle(SOLID_FILL, (int)pColorSet->colors.BAK_COLOR);
        bar(temp);
        }
    else
        bar(temp,
            (int)pColorSet->colors.BAK_COLOR,
            (int)pColorSet->colors.FILL_COLOR, (uchar*)::pattern[pattern]);
    Border::show();
    mouseShowCursor();
    }
///////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
        return;
    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    Window w(rect(10, 10, 50, 20), "window.pcy", " KNOW-HOW 4.x",
	       6, SHOW_BORDER, SHOW_BORDER, MOVE | RESIZE, 18, 19);
    w.show_window();
    w.hide();
    close_KNOW_HOW();
    closegraph();
    }
*/