/*  WINDOW.H   Window is the area on screen.
    It can remember its underground or its contents. You must first show
    window, and only then output somthing into it */

#ifndef __WINDOW_H_
#define __WINDOW_H_

#include <stdio.h>

#include <alloc.h>

#include "border.h"
#include "visible.h"
#include "dim.h"

class Window : public Border, public Visible
    {
    protected:
        char* fileName;
	int resize_status;      // FIXED, MOVE, RESIZE, MOVE_RESIZE
        int pattern;
    public:
	Window(rect coordinates, char* fName = "", char* h = "",
	       int s = 0, BORDERS b_type = SHOW_BORDER,
	       BORDERS hdr_b_type = SHOW_BORDER,
	       int res = 0, int pat = 0, int hdr_pat = 0);

        virtual ~Window() { unlink(fileName); delete fileName; }
        rect get_rectangle() { return rectangle; }
	virtual void repose(rect new_pos);

	virtual void show();
        void show_window();
        virtual void hide();

        int get_status(int status) { return resize_status & status; }
	void clrscr();
	int get_shadow() { return shadow; }

	rect user_screen();      // work area of the window, screen coords
	virtual void exe(int act = 0);

	virtual rect bound() { return screenRect(rectangle); }
	void hilite();
	void unhilite();
    };

#endif __WINDOW_H_