#include <stdlib.h>
#include "wmanager.h"
#include "alloc.h"

int* dump(int* cells)
    {
    int i = 0;
    int j = 0;
    int* cells1 = cells;
    while(cells[i] != -1 && i < 25 * 80)
        {
        if(cells[i] == -2)
            {
            i++;
            continue;
	    }
        cells1[j] = cells[i];
        i++; j++;
	}
    cells1[j] = -1;
    return cells1;
    }
/////////////////////////
int WindowManager::overlapped(Visible* object)
    {
    int num = get_number(object);
    rect r = object->bound();
    for(int i = num + 1; i <= s_used; i++)
        {
        rect b = stack[i]->bound();
        if(b.contains(r.origin) || b.contains(r.corner)
           || r.contains(b.origin) || r.contains(b.corner)
           || (r.origin.X <= b.origin.X
	    && r.corner.X >= b.origin.X
	    && r.origin.Y >= b.origin.Y
	    && r.origin.Y <= b.corner.Y)
           || (r.origin.X >= b.origin.X
            && r.origin.X <= b.corner.X
            && r.origin.Y <= b.origin.Y
            && r.corner.Y >= b.origin.Y))
            return 1;
        }
    return 0;
    }
/////////////////////////
WindowManager::~WindowManager()
    {
    char str[9];
    for(int i = 0; i <= s_used; i++)
        unlink(get_file_name(stack[i], str));
    delete stack;
    }
////////////////////////
int* WindowManager::get_cells()
    {
    rect cur_rect = stack[s_used]->bound();

    return pScreenSet->get_cells(cur_rect);
    }
/////////////////////////
int WindowManager::get_number(Visible* object)
    {
    for(int i = 0; object != stack[i]; i++)
        ;
    return i;
    }
///////////////////////
void WindowManager::add(Visible* object)
    {
    s_used++;
    stack[s_used] = object;

    if(s_size < s_used)
	stack = (Visible**)realloc(stack,
	    (s_size += DELTA) * sizeof(Visible*));
    }
////////////////////
void WindowManager::moveTo(Visible* object)
    {
    int i = get_number(object);
    for(; i < s_used; i++)    // Move object to the top
	stack[i] = stack[i + 1];
    stack[s_used] = object;
    }
///////////////////////////
void WindowManager::shift()
    {
    if(s_used > 1)
	moveTo(stack[1]);
    }
///////////////////////////
void WindowManager::remove()
    {
    s_used--;
    if(s_size - s_used > 2 * DELTA)
	stack = (Visible**)realloc(stack, (s_size -= DELTA) * sizeof(int));
    }
/////////////////////////
char* WindowManager::get_file_name(Visible* object, char* str)
    {
    int i = object->get_object_number();
    itoa(i, str, 10);
    return str;
    }
/////////////////////////////
void WindowManager::show_window(Visible* object)
    {
    if(!object->active())
	add(object);

    char str[9];
    if(object->isRet(RET_STACKED))
	{
	if(!object->active() || overlapped(object))
	    {
	    object->show();
	    if(!object->isRet(RET_SHOW))
		pcx_scr_file(object->bound(), get_file_name(object, str), 0);
	    }
	}
    else if(!object->active())
	{
	pcx_scr_file(object->bound(), get_file_name(object, str), 0);
        object->show();
	}
    moveTo(object);
    stack[s_used]->set_active(1);
    }
//////////////////////
void WindowManager::hide_window()
    {
    char str[9];
    if(stack[s_used]->isRet(RET_STACKED))
        {
        int* cells = get_cells();
        for(int i = s_used - 1; i >= 0; i--)
            {
            pcx_file_scr(get_file_name(stack[i], str),
	        stack[i]->bound().origin, cells);
            cells = dump(cells);
            }
        delete cells;
	}
    else
        {
        pcx_file_scr(get_file_name(stack[s_used], str),
	    stack[s_used]->bound().origin);
        stack[s_used]->hide();  // Final operations, delete, close ...
	}                       // For STACKED windows it does destructor.
    stack[s_used]->set_active(0);
    unlink(get_file_name(stack[s_used], str));
    remove();
    }
//////////////////////
void WindowManager::redraw_window(rect new_coord)
    {
    if(new_coord.origin.X == new_coord.corner.X)
        return;
    Visible* tmp = stack[s_used];
    hide_window();
    tmp->repose(textRect(new_coord));
    show_window(tmp);
    }
//////////////////////

