/*

  This file contains the state setup routines for all of the rendering
  methods used by Power Render and 3D cards under Direct3D.

  THIS IS FOR ADVANCED USERS ONLY!

  Adding new state functions allows you to use different blending functions
  available on 3D cards.  You cannot add different triangle functionality
  such as anti-aliasing.  However, this can be used for adding phong
  highlights by adding alpha, or translucent gouraud shaded texture, etc.
  You must be careful that one state change will not effect another, such
  as leaving a blending function turned on when another method does not
  reset this state.

  To change an existing routine or add a new rendering type, first
  #include the prstate.h file.

  Second, copy one of the routines below into your own program and
  make modifications as necessary.

  Finally, call the PR_RegisterRenderMethod function to register
  the method with the rendering pipeline. It is defined as follows:

  PR_RegisterRenderMethod (int method_number, void (*MethodProc)(),
                PR_DWORD flags)

  The flags variable is TRUE or FALSE.  TRUE means the method uses
  alpha blending and triangles will be kept in a list and presorted
  before drawing the final image.  FALSE will draw the triangles
  immediately.

  Each state function has two sections:  setting up the texture and
  lighting when the ADDPRIV_setup_data variable is TRUE, and
  setting up the correct blending functions when the ADDPRIV_setup_state
  variable is TRUE.  The function will be called twice if using
  alpha blending (determined by the flags above), first setting up
  the data, and later setting up the blending functions when the
  PR_RenderFrame function is called.

  If alpha blending is not required, the function is called once and
  both sections are performed.

  The complete rendering method list is registered using a function called
  PR_InitializeRenderMethods at the bottom of this file.  You can rename
  this and use your own set of functions if you like.

*/



void PR_LightFunc_CFLAT (void) /* 1 */
{
PR_REAL i;

  if (ADDPRIV_setup_state)
    if (last_material != ADDPRIV_mat)
      {
       wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREHANDLE, 0);
       wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHATESTENABLE, FALSE);
       wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_COLORKEYENABLE, FALSE);
	   ALPHA_OFF;

       last_material = ADDPRIV_mat;
      }

  if (ADDPRIV_setup_data)
    {
     i = ADDPRIV_facedatareal->col[0];
     ADDPRIV_r = ADDPRIV_mat->r * i;
     ADDPRIV_g = ADDPRIV_mat->g * i;
     ADDPRIV_b = ADDPRIV_mat->b * i;

     ADDPRIV_vptr1data->r = ADDPRIV_vptr2data->r = ADDPRIV_vptr3data->r = ADDPRIV_r;
     ADDPRIV_vptr1data->g = ADDPRIV_vptr2data->g = ADDPRIV_vptr3data->g = ADDPRIV_g;
     ADDPRIV_vptr1data->b = ADDPRIV_vptr2data->b = ADDPRIV_vptr3data->b = ADDPRIV_b;
    }
}


void PR_LightFunc_FLAT (void)  /* 2 */
{
PR_REAL i;


  if (ADDPRIV_setup_state)
    if (last_material != ADDPRIV_mat)
      {
       wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREHANDLE, 0);
       wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHATESTENABLE, FALSE);
       wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_COLORKEYENABLE, FALSE);
	   ALPHA_OFF;
       last_material = ADDPRIV_mat;
      }

  if (ADDPRIV_setup_data)
    {
     PR_WORKFACEFLAGS = !(ADDPRIV_face->flags & FFLAG_BACK_VISIBLE);
     PR_CalcFaceLightingD3D (ADDPRIV_face);

     i = ADDPRIV_facedatareal->col[0];          /* Add the precalced light */
     if (i > 0)
       {
        ADDPRIV_r += ADDPRIV_mat->r * i;
        ADDPRIV_g += ADDPRIV_mat->g * i;
        ADDPRIV_b += ADDPRIV_mat->b * i;
        CLAMP_RGB;
       }

     ADDPRIV_vptr1data->r = ADDPRIV_vptr2data->r = ADDPRIV_vptr3data->r = ADDPRIV_vptr1data->r = ADDPRIV_r;
     ADDPRIV_vptr1data->g = ADDPRIV_vptr2data->g = ADDPRIV_vptr3data->g = ADDPRIV_vptr1data->g = ADDPRIV_g;
     ADDPRIV_vptr1data->b = ADDPRIV_vptr2data->b = ADDPRIV_vptr3data->b = ADDPRIV_vptr1data->b = ADDPRIV_b;
    }
}


void PR_LightFunc_CGOURAUD (void)  /* 3 */
{
PR_REAL i;

  if (ADDPRIV_setup_state)
   if (last_material != ADDPRIV_mat)
     {
       wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREHANDLE, 0L);
       wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHATESTENABLE, FALSE);
       wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_COLORKEYENABLE, FALSE);
	   ALPHA_OFF;
      last_material = ADDPRIV_mat;
     }

  if (ADDPRIV_setup_data)
    {
     i = ADDPRIV_facedatareal->col[0];
     ADDPRIV_vptr1data->r = ADDPRIV_mat->r * i;
     ADDPRIV_vptr1data->g = ADDPRIV_mat->g * i;
     ADDPRIV_vptr1data->b = ADDPRIV_mat->b * i;

     i = ADDPRIV_facedatareal->col[1];
     ADDPRIV_vptr2data->r = ADDPRIV_mat->r * i;
     ADDPRIV_vptr2data->g = ADDPRIV_mat->g * i;
     ADDPRIV_vptr2data->b = ADDPRIV_mat->b * i;

     i = ADDPRIV_facedatareal->col[2];
     ADDPRIV_vptr3data->r = ADDPRIV_mat->r * i;
     ADDPRIV_vptr3data->g = ADDPRIV_mat->g * i;
     ADDPRIV_vptr3data->b = ADDPRIV_mat->b * i;
    }
}



void PR_LightFunc_GOURAUD (void)  /* 4 */
{
PR_REAL i;


  if (ADDPRIV_setup_state)
    if (last_material != ADDPRIV_mat)
      {
       wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREHANDLE, 0L);
       wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHATESTENABLE, FALSE);
       wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_COLORKEYENABLE, FALSE);
	   ALPHA_OFF;

       last_material = ADDPRIV_mat;
      }

  if (ADDPRIV_setup_data)
    {
     PR_WORKFACEFLAGS = !(ADDPRIV_face->flags & FFLAG_BACK_VISIBLE);
     if (ADDPRIV_vptr1data->dotproduct != ADDPRIV_material_num)
       {
        ADDPRIV_vptr1data->dotproduct = ADDPRIV_material_num;
        PR_CalcVertexLightingD3D (ADDPRIV_vptr1, ADDPRIV_vptr1data);

        i = ADDPRIV_facedatareal->col[0];          /* Add the precalced light */
        if (i > 0)
          {
           ADDPRIV_r += ADDPRIV_mat->r * i;
           ADDPRIV_g += ADDPRIV_mat->g * i;
           ADDPRIV_b += ADDPRIV_mat->b * i;
           CLAMP_RGB;
          }
 
        ADDPRIV_vptr1data->r = ADDPRIV_r;
        ADDPRIV_vptr1data->g = ADDPRIV_g;
        ADDPRIV_vptr1data->b = ADDPRIV_b;
       }

     if (ADDPRIV_vptr2data->dotproduct != ADDPRIV_material_num)
       {
        ADDPRIV_vptr2data->dotproduct = ADDPRIV_material_num;
        PR_CalcVertexLightingD3D (ADDPRIV_vptr2, ADDPRIV_vptr2data);

        i = ADDPRIV_facedatareal->col[1];          /* Add the precalced light */
        if (i > 0)
          {
           ADDPRIV_r += ADDPRIV_mat->r * i;
           ADDPRIV_g += ADDPRIV_mat->g * i;
           ADDPRIV_b += ADDPRIV_mat->b * i;
           CLAMP_RGB;
          }
   
        ADDPRIV_vptr2data->r = ADDPRIV_r;
        ADDPRIV_vptr2data->g = ADDPRIV_g;
        ADDPRIV_vptr2data->b = ADDPRIV_b;
       }

     if (ADDPRIV_vptr3data->dotproduct != ADDPRIV_material_num)
       {
        ADDPRIV_vptr3data->dotproduct = ADDPRIV_material_num;
        PR_CalcVertexLightingD3D (ADDPRIV_vptr3, ADDPRIV_vptr3data);
   
        i = ADDPRIV_facedatareal->col[2];          /* Add the precalced light */
        if (i > 0)
          {
           ADDPRIV_r += ADDPRIV_mat->r * i;
           ADDPRIV_g += ADDPRIV_mat->g * i;
           ADDPRIV_b += ADDPRIV_mat->b * i;
           CLAMP_RGB;
          }
   
        ADDPRIV_vptr3data->r = ADDPRIV_r;
        ADDPRIV_vptr3data->g = ADDPRIV_g;
        ADDPRIV_vptr3data->b = ADDPRIV_b;
       }
   }
}

void PR_LightFunc_DECAL (void)    /* 5 */
{
PR_FACE_DATA_REAL *faceptr;

  if (ADDPRIV_setup_state)
   if (last_material != ADDPRIV_mat)
    {
     PR_SelectTexture (ADDPRIV_mat->texture_number);

     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREMAPBLEND, D3DTBLEND_DECAL);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREPERSPECTIVE, TRUE);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHATESTENABLE, FALSE);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHAFUNC, D3DCMP_ALWAYS);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_COLORKEYENABLE, FALSE);
     ALPHA_OFF;

     last_material = ADDPRIV_mat;
    }

  if (ADDPRIV_setup_data)
    {
     faceptr = (PR_FACE_DATA_REAL *)&ADDPRIV_face->face_data;
     SET_TMAP(ADDPRIV_mat, ADDPRIV_vptr1data, ADDPRIV_vptr2data, ADDPRIV_vptr3data, ADDPRIV_vptr1, ADDPRIV_vptr2, ADDPRIV_vptr3, ADDPRIV_vptr1data,ADDPRIV_vptr2data,ADDPRIV_vptr3data,faceptr);
    }

}


void PR_LightFunc_XDECAL (void)    /* 6 */
{
PR_FACE_DATA_REAL *faceptr;

  if (ADDPRIV_setup_state)
   if (last_material != ADDPRIV_mat)
    {
     PR_SelectTexture (ADDPRIV_mat->texture_number);

     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREMAPBLEND, D3DTBLEND_DECAL);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_SHADEMODE, D3DSHADE_FLAT);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREPERSPECTIVE, TRUE);

     if (PR_D3D_Caps.AlphaBlend)
       {
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_BLENDENABLE, TRUE);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_SRCBLEND, D3DBLEND_SRCALPHA);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_DESTBLEND, D3DBLEND_INVSRCALPHA);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHATESTENABLE, TRUE);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHAREF, 1);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHAFUNC, D3DCMP_GREATEREQUAL);
       }
	 else if (PR_D3D_Caps.AlphaStipple)
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_STIPPLEDALPHA, FALSE);

     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_COLORKEYENABLE, TRUE);

     last_material = ADDPRIV_mat;
    }


  if (ADDPRIV_setup_data)
    {
     ADDPRIV_vptr1data->a = 255;
     ADDPRIV_vptr2data->a = 255;
     ADDPRIV_vptr3data->a = 255;

     faceptr = (PR_FACE_DATA_REAL *)&ADDPRIV_face->face_data;
     SET_TMAP(ADDPRIV_mat, ADDPRIV_vptr1data, ADDPRIV_vptr2data, ADDPRIV_vptr3data, ADDPRIV_vptr1, ADDPRIV_vptr2, ADDPRIV_vptr3, ADDPRIV_vptr1data,ADDPRIV_vptr2data,ADDPRIV_vptr3data,faceptr);
    }
}


void PR_LightFunc_CFLATTEXT (void)  /* 7 */
{
PR_REAL i;
PR_FACE_DATA_REAL *faceptr;

  if (ADDPRIV_setup_state)
   if (last_material != ADDPRIV_mat)
    {
     PR_SelectTexture (ADDPRIV_mat->texture_number);

     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREMAPBLEND, D3DTBLEND_MODULATE);
	 wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_SHADEMODE, D3DSHADE_FLAT);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREPERSPECTIVE, TRUE);

     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHATESTENABLE, FALSE);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_COLORKEYENABLE, FALSE);
	 ALPHA_OFF;

     last_material = ADDPRIV_mat;
    }

  if (ADDPRIV_setup_data)
    {
     i = ADDPRIV_facedatareal->col[0];
     ADDPRIV_r = ADDPRIV_mat->r * i;
     ADDPRIV_g = ADDPRIV_mat->g * i;
     ADDPRIV_b = ADDPRIV_mat->b * i;

     ADDPRIV_vptr1data->r = ADDPRIV_vptr2data->r = ADDPRIV_vptr3data->r = ADDPRIV_r;
     ADDPRIV_vptr1data->g = ADDPRIV_vptr2data->g = ADDPRIV_vptr3data->g = ADDPRIV_g;
     ADDPRIV_vptr1data->b = ADDPRIV_vptr2data->b = ADDPRIV_vptr3data->b = ADDPRIV_b;

     faceptr = (PR_FACE_DATA_REAL *)&ADDPRIV_face->face_data;
     SET_TMAP(ADDPRIV_mat, ADDPRIV_vptr1data, ADDPRIV_vptr2data, ADDPRIV_vptr3data, ADDPRIV_vptr1, ADDPRIV_vptr2, ADDPRIV_vptr3, ADDPRIV_vptr1data,ADDPRIV_vptr2data,ADDPRIV_vptr3data,faceptr);
    }
}


void PR_LightFunc_XCFLATTEXT (void)  /* 8 */
{
PR_REAL i;
PR_FACE_DATA_REAL *faceptr;

  if (ADDPRIV_setup_state)
   if (last_material != ADDPRIV_mat)
    {
     PR_SelectTexture (ADDPRIV_mat->texture_number);

     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREMAPBLEND, D3DTBLEND_MODULATE);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_SHADEMODE, D3DSHADE_FLAT);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREPERSPECTIVE, TRUE);

     if (PR_D3D_Caps.AlphaBlend)
       {
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_BLENDENABLE, TRUE);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHATESTENABLE, TRUE);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_SRCBLEND, D3DBLEND_SRCALPHA);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_DESTBLEND, D3DBLEND_INVSRCALPHA);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHAREF, 1);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHAFUNC, D3DCMP_GREATEREQUAL);
       }
	 else if (PR_D3D_Caps.AlphaStipple)
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_STIPPLEDALPHA, FALSE);

     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_COLORKEYENABLE, TRUE);


     last_material = ADDPRIV_mat;
    }

  if (ADDPRIV_setup_data)
    {
     i = ADDPRIV_facedatareal->col[0];
     ADDPRIV_r = ADDPRIV_mat->r * i;
     ADDPRIV_g = ADDPRIV_mat->g * i;
     ADDPRIV_b = ADDPRIV_mat->b * i;

     ADDPRIV_vptr1data->r = ADDPRIV_vptr2data->r = ADDPRIV_vptr3data->r = ADDPRIV_r;
     ADDPRIV_vptr1data->g = ADDPRIV_vptr2data->g = ADDPRIV_vptr3data->g = ADDPRIV_g;
     ADDPRIV_vptr1data->b = ADDPRIV_vptr2data->b = ADDPRIV_vptr3data->b = ADDPRIV_b;

     faceptr = (PR_FACE_DATA_REAL *)&ADDPRIV_face->face_data;
     SET_TMAP(ADDPRIV_mat, ADDPRIV_vptr1data, ADDPRIV_vptr2data, ADDPRIV_vptr3data, ADDPRIV_vptr1, ADDPRIV_vptr2, ADDPRIV_vptr3, ADDPRIV_vptr1data,ADDPRIV_vptr2data,ADDPRIV_vptr3data,faceptr);
    }
}


void PR_LightFunc_FLATTEXT (void)   /* 9 */
{
PR_FACE_DATA_REAL *faceptr;
PR_REAL i;


  if (ADDPRIV_setup_state)
   if (last_material != ADDPRIV_mat)
    {
     PR_SelectTexture (ADDPRIV_mat->texture_number);

     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREMAPBLEND, D3DTBLEND_MODULATE);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_SHADEMODE, D3DSHADE_FLAT);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREPERSPECTIVE, TRUE);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_COLORKEYENABLE, FALSE);

     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHATESTENABLE, FALSE);
	 ALPHA_OFF;

     last_material = ADDPRIV_mat;
    }

  if (ADDPRIV_setup_data)
    {
     PR_WORKFACEFLAGS = !(ADDPRIV_face->flags & FFLAG_BACK_VISIBLE);
     PR_CalcFaceLightingD3D (ADDPRIV_face);

     i = ADDPRIV_facedatareal->col[0];          /* Add the precalced light */
     if (i > 0)
       {
        ADDPRIV_r += ADDPRIV_mat->r * i;
        ADDPRIV_g += ADDPRIV_mat->g * i;
        ADDPRIV_b += ADDPRIV_mat->b * i;
        CLAMP_RGB;
       }

     ADDPRIV_vptr1data->r = ADDPRIV_vptr2data->r = ADDPRIV_vptr3data->r = ADDPRIV_r;
     ADDPRIV_vptr1data->g = ADDPRIV_vptr2data->g = ADDPRIV_vptr3data->g = ADDPRIV_g;
     ADDPRIV_vptr1data->b = ADDPRIV_vptr2data->b = ADDPRIV_vptr3data->b = ADDPRIV_b;

     faceptr = (PR_FACE_DATA_REAL *)&ADDPRIV_face->face_data;
     SET_TMAP(ADDPRIV_mat, ADDPRIV_vptr1data, ADDPRIV_vptr2data, ADDPRIV_vptr3data, ADDPRIV_vptr1, ADDPRIV_vptr2, ADDPRIV_vptr3, ADDPRIV_vptr1data,ADDPRIV_vptr2data,ADDPRIV_vptr3data,faceptr);
   }
}



void PR_LightFunc_XFLATTEXT (void)   /* 10 */
{
PR_FACE_DATA_REAL *faceptr;
PR_REAL i;


  if (ADDPRIV_setup_state)
   if (last_material != ADDPRIV_mat)
    {
     PR_SelectTexture (ADDPRIV_mat->texture_number);

     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREMAPBLEND, D3DTBLEND_MODULATE);
	 wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_SHADEMODE, D3DSHADE_FLAT);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREPERSPECTIVE, TRUE);

     if (PR_D3D_Caps.AlphaBlend)
       {
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_BLENDENABLE, TRUE);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHATESTENABLE, TRUE);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_SRCBLEND, D3DBLEND_SRCALPHA);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_DESTBLEND, D3DBLEND_INVSRCALPHA);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHAREF, 1);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHAFUNC, D3DCMP_GREATEREQUAL);
       }
     else if (PR_D3D_Caps.AlphaStipple)
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_STIPPLEDALPHA, FALSE);
               
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_COLORKEYENABLE, TRUE);

     last_material = ADDPRIV_mat;
    }


  if (ADDPRIV_setup_data)
    {
     PR_WORKFACEFLAGS = !(ADDPRIV_face->flags & FFLAG_BACK_VISIBLE);
     PR_CalcFaceLightingD3D (ADDPRIV_face);

     i = ADDPRIV_facedatareal->col[0];          /* Add the precalced light */
     if (i > 0)
       {
        ADDPRIV_r += ADDPRIV_mat->r * i;
        ADDPRIV_g += ADDPRIV_mat->g * i;
        ADDPRIV_b += ADDPRIV_mat->b * i;
        CLAMP_RGB;
       }

     ADDPRIV_vptr1data->r = ADDPRIV_vptr2data->r = ADDPRIV_vptr3data->r = ADDPRIV_r;
     ADDPRIV_vptr1data->g = ADDPRIV_vptr2data->g = ADDPRIV_vptr3data->g = ADDPRIV_g;
     ADDPRIV_vptr1data->b = ADDPRIV_vptr2data->b = ADDPRIV_vptr3data->b = ADDPRIV_b;

     ADDPRIV_vptr1data->a = 255;
     ADDPRIV_vptr2data->a = 255;
     ADDPRIV_vptr3data->a = 255;
  
     faceptr = (PR_FACE_DATA_REAL *)&ADDPRIV_face->face_data;
     SET_TMAP(ADDPRIV_mat, ADDPRIV_vptr1data, ADDPRIV_vptr2data, ADDPRIV_vptr3data, ADDPRIV_vptr1, ADDPRIV_vptr2, ADDPRIV_vptr3, ADDPRIV_vptr1data,ADDPRIV_vptr2data,ADDPRIV_vptr3data,faceptr);
    }
}



void PR_LightFunc_CGOURAUDTEXT (void)  /* 11 */
{
PR_FACE_DATA_REAL *faceptr;
PR_REAL i;

  if (ADDPRIV_setup_state)
   if (last_material != ADDPRIV_mat)
    {
     PR_SelectTexture (ADDPRIV_mat->texture_number);

     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREMAPBLEND, D3DTBLEND_MODULATE);
	 wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_SHADEMODE, D3DSHADE_GOURAUD);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREPERSPECTIVE, TRUE);

     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_COLORKEYENABLE, FALSE);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHATESTENABLE, FALSE);
	 ALPHA_OFF;

     last_material = ADDPRIV_mat;
    }


  if (ADDPRIV_setup_data)
    {
     i = ADDPRIV_facedatareal->col[0];
     ADDPRIV_vptr1data->r = ADDPRIV_mat->r * i;
     ADDPRIV_vptr1data->g = ADDPRIV_mat->g * i;
     ADDPRIV_vptr1data->b = ADDPRIV_mat->b * i;

     i = ADDPRIV_facedatareal->col[1];
     ADDPRIV_vptr2data->r = ADDPRIV_mat->r * i;
     ADDPRIV_vptr2data->g = ADDPRIV_mat->g * i;
     ADDPRIV_vptr2data->b = ADDPRIV_mat->b * i;

     i = ADDPRIV_facedatareal->col[2];
     ADDPRIV_vptr3data->r = ADDPRIV_mat->r * i;
     ADDPRIV_vptr3data->g = ADDPRIV_mat->g * i;
     ADDPRIV_vptr3data->b = ADDPRIV_mat->b * i;

     faceptr = (PR_FACE_DATA_REAL *)&ADDPRIV_face->face_data;
     SET_TMAP(ADDPRIV_mat, ADDPRIV_vptr1data, ADDPRIV_vptr2data, ADDPRIV_vptr3data, ADDPRIV_vptr1, ADDPRIV_vptr2, ADDPRIV_vptr3, ADDPRIV_vptr1data,ADDPRIV_vptr2data,ADDPRIV_vptr3data,faceptr);
    }
}


void PR_LightFunc_XCGOURAUDTEXT (void)  /* 12 */
{
PR_FACE_DATA_REAL *faceptr;
PR_REAL i;

  if (ADDPRIV_setup_state)
   if (last_material != ADDPRIV_mat)
    {
     PR_SelectTexture (ADDPRIV_mat->texture_number);

     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREMAPBLEND, D3DTBLEND_MODULATE);
	 wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_SHADEMODE, D3DSHADE_GOURAUD);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREPERSPECTIVE, TRUE);

     if (PR_D3D_Caps.AlphaBlend)
       {
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_BLENDENABLE, TRUE);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHATESTENABLE, TRUE);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_SRCBLEND, D3DBLEND_SRCALPHA);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_DESTBLEND, D3DBLEND_INVSRCALPHA);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHAREF, 1);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHAFUNC, D3DCMP_GREATEREQUAL);
       }
	 else if (PR_D3D_Caps.AlphaStipple)
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_STIPPLEDALPHA, FALSE);

       wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_COLORKEYENABLE, TRUE);

     last_material = ADDPRIV_mat;
    }

  if (ADDPRIV_setup_data)
    {
     i = ADDPRIV_facedatareal->col[0];
     ADDPRIV_vptr1data->r = ADDPRIV_mat->r * i;
     ADDPRIV_vptr1data->g = ADDPRIV_mat->g * i;
     ADDPRIV_vptr1data->b = ADDPRIV_mat->b * i;

     i = ADDPRIV_facedatareal->col[1];
     ADDPRIV_vptr2data->r = ADDPRIV_mat->r * i;
     ADDPRIV_vptr2data->g = ADDPRIV_mat->g * i;
     ADDPRIV_vptr2data->b = ADDPRIV_mat->b * i;

     i = ADDPRIV_facedatareal->col[2];
     ADDPRIV_vptr3data->r = ADDPRIV_mat->r * i;
     ADDPRIV_vptr3data->g = ADDPRIV_mat->g * i;
     ADDPRIV_vptr3data->b = ADDPRIV_mat->b * i;

     faceptr = (PR_FACE_DATA_REAL *)&ADDPRIV_face->face_data;
     SET_TMAP(ADDPRIV_mat, ADDPRIV_vptr1data, ADDPRIV_vptr2data, ADDPRIV_vptr3data, ADDPRIV_vptr1, ADDPRIV_vptr2, ADDPRIV_vptr3, ADDPRIV_vptr1data,ADDPRIV_vptr2data,ADDPRIV_vptr3data,faceptr);
    }
}




void PR_LightFunc_GOURAUDTEXT (void)  /* 13 */
{
PR_FACE_DATA_REAL *faceptr;
PR_REAL i;


  if (ADDPRIV_setup_state)
   if (last_material != ADDPRIV_mat)
    {
     PR_SelectTexture (ADDPRIV_mat->texture_number);

     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREMAPBLEND, D3DTBLEND_MODULATE);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_SHADEMODE, D3DSHADE_GOURAUD);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREPERSPECTIVE, TRUE);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_COLORKEYENABLE, FALSE);

     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHATESTENABLE, FALSE);
     ALPHA_OFF;     

     if (PR_D3D_Caps.AlphaStipple)
       {
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_STIPPLEDALPHA, FALSE);
	   }

     last_material = ADDPRIV_mat;
    }

  if (ADDPRIV_setup_data)
    {
     PR_WORKFACEFLAGS = !(ADDPRIV_face->flags & FFLAG_BACK_VISIBLE);

     if (ADDPRIV_vptr1data->dotproduct != ADDPRIV_material_num)
       {
        PR_CalcVertexLightingD3D (ADDPRIV_vptr1, ADDPRIV_vptr1data);

        i = ADDPRIV_facedatareal->col[0];          /* Add the precalced light */
        if (i > 0)
          {
           ADDPRIV_r += ADDPRIV_mat->r * i;
           ADDPRIV_g += ADDPRIV_mat->g * i;
           ADDPRIV_b += ADDPRIV_mat->b * i;
           CLAMP_RGB;
           ADDPRIV_vptr1data->dotproduct = -1;
          }
        else
          ADDPRIV_vptr1data->dotproduct = ADDPRIV_material_num;
   
        ADDPRIV_vptr1data->r = ADDPRIV_r;
        ADDPRIV_vptr1data->g = ADDPRIV_g;
        ADDPRIV_vptr1data->b = ADDPRIV_b;
   
       }

     if (ADDPRIV_vptr2data->dotproduct != ADDPRIV_material_num)
       {
        PR_CalcVertexLightingD3D (ADDPRIV_vptr2, ADDPRIV_vptr2data);
   
        i = ADDPRIV_facedatareal->col[1];          /* Add the precalced light */
        if (i > 0)
          {
           ADDPRIV_r += ADDPRIV_mat->r * i;
           ADDPRIV_g += ADDPRIV_mat->g * i;
           ADDPRIV_b += ADDPRIV_mat->b * i;
           CLAMP_RGB;
           ADDPRIV_vptr2data->dotproduct = -1;
          }
        else
          ADDPRIV_vptr2data->dotproduct = ADDPRIV_material_num;
   
        ADDPRIV_vptr2data->r = ADDPRIV_r;
        ADDPRIV_vptr2data->g = ADDPRIV_g;
        ADDPRIV_vptr2data->b = ADDPRIV_b;
       }
   
     if (ADDPRIV_vptr3data->dotproduct != ADDPRIV_material_num)
       {
        PR_CalcVertexLightingD3D (ADDPRIV_vptr3, ADDPRIV_vptr3data);
   
        i = ADDPRIV_facedatareal->col[2];          /* Add the precalced light */
        if (i > 0)
          {
           ADDPRIV_r += ADDPRIV_mat->r * i;
           ADDPRIV_g += ADDPRIV_mat->g * i;
           ADDPRIV_b += ADDPRIV_mat->b * i;
           CLAMP_RGB;
           ADDPRIV_vptr3data->dotproduct = -1;
          }
        else
          ADDPRIV_vptr3data->dotproduct = ADDPRIV_material_num;

        ADDPRIV_vptr3data->r = ADDPRIV_r;
        ADDPRIV_vptr3data->g = ADDPRIV_g;
        ADDPRIV_vptr3data->b = ADDPRIV_b;
       }
   
     faceptr = (PR_FACE_DATA_REAL *)&ADDPRIV_face->face_data;
     SET_TMAP(ADDPRIV_mat, ADDPRIV_vptr1data, ADDPRIV_vptr2data, ADDPRIV_vptr3data, ADDPRIV_vptr1, ADDPRIV_vptr2, ADDPRIV_vptr3, ADDPRIV_vptr1data,ADDPRIV_vptr2data,ADDPRIV_vptr3data,faceptr);
    }
}




void PR_LightFunc_XGOURAUDTEXT (void)  /* 14 */
{
PR_FACE_DATA_REAL *faceptr;
PR_REAL i;

  if (ADDPRIV_setup_state)
   if (last_material != ADDPRIV_mat)
    {
     PR_SelectTexture (ADDPRIV_mat->texture_number);

     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREMAPBLEND, D3DTBLEND_MODULATEALPHA);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_SHADEMODE, D3DSHADE_GOURAUD);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREPERSPECTIVE, TRUE);

     if (PR_D3D_Caps.AlphaBlend)
       {
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_BLENDENABLE, TRUE);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_SRCBLEND, D3DBLEND_SRCALPHA);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_DESTBLEND, D3DBLEND_INVSRCALPHA);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHATESTENABLE, TRUE);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHAREF, 1);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHAFUNC, D3DCMP_GREATEREQUAL);
	   }
	 else if (PR_D3D_Caps.AlphaStipple)
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_STIPPLEDALPHA, FALSE);
     
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_COLORKEYENABLE, TRUE);

     last_material = ADDPRIV_mat;
    }


  if (ADDPRIV_setup_data)
    {
     PR_WORKFACEFLAGS = !(ADDPRIV_face->flags & FFLAG_BACK_VISIBLE);

     if (ADDPRIV_vptr1data->dotproduct != ADDPRIV_material_num)
       {
        ADDPRIV_vptr1data->dotproduct = ADDPRIV_material_num;
        PR_CalcVertexLightingD3D (ADDPRIV_vptr1, ADDPRIV_vptr1data);
   
        i = ADDPRIV_facedatareal->col[0];          /* Add the precalced light */
        if (i > 0)
          {
           ADDPRIV_r += ADDPRIV_mat->r * i;
           ADDPRIV_g += ADDPRIV_mat->g * i;
           ADDPRIV_b += ADDPRIV_mat->b * i;
           CLAMP_RGB;
          }
        ADDPRIV_vptr1data->r = ADDPRIV_r;
        ADDPRIV_vptr1data->g = ADDPRIV_g;
        ADDPRIV_vptr1data->b = ADDPRIV_b;
       }
   
   
     if (ADDPRIV_vptr2data->dotproduct != ADDPRIV_material_num)
       {
        ADDPRIV_vptr2data->dotproduct = ADDPRIV_material_num;
        PR_CalcVertexLightingD3D (ADDPRIV_vptr2, ADDPRIV_vptr2data);
   
        i = ADDPRIV_facedatareal->col[1];          /* Add the precalced light */
        if (i > 0)
          {
           ADDPRIV_r += ADDPRIV_mat->r * i;
           ADDPRIV_g += ADDPRIV_mat->g * i;
           ADDPRIV_b += ADDPRIV_mat->b * i;
           CLAMP_RGB;
          }
        ADDPRIV_vptr2data->r = ADDPRIV_r;
        ADDPRIV_vptr2data->g = ADDPRIV_g;
        ADDPRIV_vptr2data->b = ADDPRIV_b;
       }
   
     if (ADDPRIV_vptr3data->dotproduct != ADDPRIV_material_num)
       {
        ADDPRIV_vptr3data->dotproduct = ADDPRIV_material_num;
        PR_CalcVertexLightingD3D (ADDPRIV_vptr3, ADDPRIV_vptr3data);
   
        i = ADDPRIV_facedatareal->col[2];          /* Add the precalced light */
        if (i > 0)
          {
           ADDPRIV_r += ADDPRIV_mat->r * i;
           ADDPRIV_g += ADDPRIV_mat->g * i;
           ADDPRIV_b += ADDPRIV_mat->b * i;
           CLAMP_RGB;
          }
        ADDPRIV_vptr3data->r = ADDPRIV_r;
        ADDPRIV_vptr3data->g = ADDPRIV_g;
        ADDPRIV_vptr3data->b = ADDPRIV_b;
       }

     ADDPRIV_vptr1data->a = 255;
     ADDPRIV_vptr2data->a = 255;
     ADDPRIV_vptr3data->a = 255;
   
     faceptr = (PR_FACE_DATA_REAL *)&ADDPRIV_face->face_data;
     SET_TMAP(ADDPRIV_mat, ADDPRIV_vptr1data, ADDPRIV_vptr2data, ADDPRIV_vptr3data, ADDPRIV_vptr1, ADDPRIV_vptr2, ADDPRIV_vptr3, ADDPRIV_vptr1data,ADDPRIV_vptr2data,ADDPRIV_vptr3data,faceptr);
    }
}



void PR_LightFunc_TRANSTEXT (void)    /* 15 */
{
PR_FACE_DATA_REAL *faceptr;

  if (ADDPRIV_setup_state)
   if (last_material != ADDPRIV_mat)
    {
     PR_SelectTexture (ADDPRIV_mat->texture_number);

     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREMAPBLEND, D3DTBLEND_DECAL);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREPERSPECTIVE, TRUE);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_SHADEMODE, D3DSHADE_FLAT);

     if (PR_D3D_Caps.AlphaBlend)
       {
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_BLENDENABLE, TRUE);     
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHATESTENABLE, FALSE);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_SRCBLEND, D3DBLEND_SRCALPHA);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_DESTBLEND, D3DBLEND_INVSRCALPHA);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_COLORKEYENABLE, FALSE);
       }
     else if (PR_D3D_Caps.AlphaStipple)
       {
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_STIPPLEDALPHA, TRUE);
	   }


     last_material = ADDPRIV_mat;
    }


  if (ADDPRIV_setup_data)
    {
     ADDPRIV_vptr1data->a = ADDPRIV_mat->a;
     ADDPRIV_vptr2data->a = ADDPRIV_mat->a;
     ADDPRIV_vptr3data->a = ADDPRIV_mat->a;
 
     faceptr = (PR_FACE_DATA_REAL *)&ADDPRIV_face->face_data;
     SET_TMAP(ADDPRIV_mat, ADDPRIV_vptr1data, ADDPRIV_vptr2data, ADDPRIV_vptr3data, ADDPRIV_vptr1, ADDPRIV_vptr2, ADDPRIV_vptr3, ADDPRIV_vptr1data,ADDPRIV_vptr2data,ADDPRIV_vptr3data,faceptr);
    }
}


void PR_LightFunc_XTRANSTEXT (void)    /* 16 */
{
PR_FACE_DATA_REAL *faceptr;

  if (ADDPRIV_setup_state)
   if (last_material != ADDPRIV_mat)
    {
     PR_SelectTexture (ADDPRIV_mat->texture_number);

     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREPERSPECTIVE, TRUE);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_SHADEMODE, D3DSHADE_FLAT);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_COLORKEYENABLE, TRUE);
    

     if (PR_D3D_Caps.AlphaBlend)
       {
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREMAPBLEND, D3DTBLEND_MODULATEALPHA);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_BLENDENABLE, TRUE);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_SRCBLEND, D3DBLEND_SRCALPHA);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_DESTBLEND, D3DBLEND_INVSRCALPHA);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHATESTENABLE, TRUE);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHAREF, 1);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHAFUNC, D3DCMP_GREATEREQUAL);
       }
     else if (PR_D3D_Caps.AlphaStipple)
       {
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREMAPBLEND, D3DTBLEND_DECAL);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_STIPPLEDALPHA, TRUE);
	   }

     last_material = ADDPRIV_mat;
    }

  if (ADDPRIV_setup_data)
    {
     ADDPRIV_vptr1data->a = ADDPRIV_mat->a;
     ADDPRIV_vptr2data->a = ADDPRIV_mat->a;
     ADDPRIV_vptr3data->a = ADDPRIV_mat->a;

     ADDPRIV_vptr1data->r = ADDPRIV_vptr2data->r = ADDPRIV_vptr3data->r = 255.0f;
     ADDPRIV_vptr1data->g = ADDPRIV_vptr2data->g = ADDPRIV_vptr3data->g = 255.0f;
     ADDPRIV_vptr1data->b = ADDPRIV_vptr2data->b = ADDPRIV_vptr3data->b = 255.0f;

     faceptr = (PR_FACE_DATA_REAL *)&ADDPRIV_face->face_data;
     SET_TMAP(ADDPRIV_mat, ADDPRIV_vptr1data, ADDPRIV_vptr2data, ADDPRIV_vptr3data, ADDPRIV_vptr1, ADDPRIV_vptr2, ADDPRIV_vptr3, ADDPRIV_vptr1data,ADDPRIV_vptr2data,ADDPRIV_vptr3data,faceptr);
    }
}


void PR_LightFunc_LIGHTMAPA (void)    /* 17 */
{
PR_FACE_DATA_REAL *faceptr;

  if (ADDPRIV_setup_state)
   if (last_material != ADDPRIV_mat)
    {
     PR_SelectTexture (ADDPRIV_mat->texture_number);

     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_SHADEMODE, D3DSHADE_FLAT);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREMAPBLEND, D3DTBLEND_DECAL);
     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_TEXTUREPERSPECTIVE, TRUE);

     if (PR_D3D_Caps.AlphaBlend)
       {
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_BLENDENABLE, TRUE);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_ALPHATESTENABLE, FALSE);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_SRCBLEND, D3DBLEND_SRCALPHA);
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_DESTBLEND, D3DBLEND_ONE);
       }
     else if (PR_D3D_Caps.AlphaStipple)
       {
        wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_STIPPLEDALPHA, TRUE);
	   }

     wgtd3ddev->lpVtbl->SetRenderState(wgtd3ddev, D3DRENDERSTATE_COLORKEYENABLE, FALSE);

     last_material = ADDPRIV_mat;
    }

  if (ADDPRIV_setup_data)
    {
     ADDPRIV_vptr1data->a = ADDPRIV_mat->a;
     ADDPRIV_vptr2data->a = ADDPRIV_mat->a;
     ADDPRIV_vptr3data->a = ADDPRIV_mat->a;

    ADDPRIV_vptr1data->r = ADDPRIV_vptr2data->r = ADDPRIV_vptr3data->r = 255.0f;
    ADDPRIV_vptr1data->g = ADDPRIV_vptr2data->g = ADDPRIV_vptr3data->g = 255.0f;
    ADDPRIV_vptr1data->b = ADDPRIV_vptr2data->b = ADDPRIV_vptr3data->b = 255.0f;

     faceptr = (PR_FACE_DATA_REAL *)&ADDPRIV_face->face_data;
     SET_TMAP(ADDPRIV_mat, ADDPRIV_vptr1data, ADDPRIV_vptr2data, ADDPRIV_vptr3data, ADDPRIV_vptr1, ADDPRIV_vptr2, ADDPRIV_vptr3, ADDPRIV_vptr1data,ADDPRIV_vptr2data,ADDPRIV_vptr3data,faceptr);
    }
}




#define L_CFLAT         PR_LightFunc_CFLAT
#define L_FLAT          PR_LightFunc_FLAT
#define L_CGOURAUD      PR_LightFunc_CGOURAUD
#define L_GOURAUD       PR_LightFunc_GOURAUD
#define L_DECAL         PR_LightFunc_DECAL
#define L_XDECAL        PR_LightFunc_XDECAL
#define L_CFLATTEXT     PR_LightFunc_CFLATTEXT
#define L_XCFLATTEXT    PR_LightFunc_XCFLATTEXT
#define L_FLATTEXT      PR_LightFunc_FLATTEXT
#define L_XFLATTEXT     PR_LightFunc_XFLATTEXT
#define L_CGOURAUDTEXT  PR_LightFunc_CGOURAUDTEXT
#define L_XGOURAUDTEXT  PR_LightFunc_XGOURAUDTEXT
#define L_XCGOURAUDTEXT PR_LightFunc_XCGOURAUDTEXT
#define L_GOURAUDTEXT   PR_LightFunc_GOURAUDTEXT
#define L_TRANSTEXT     PR_LightFunc_TRANSTEXT
#define L_XTRANSTEXT    PR_LightFunc_XTRANSTEXT
#define L_LIGHTMAPA     PR_LightFunc_LIGHTMAPA
#define L_LIGHTMAPM     PR_LightFunc_LIGHTMAPA


void (*PR_LightMethod[256])();
PR_DWORD PR_MethodFlags[256];

void PR_RegisterRenderMethod (int method_number, void (*MethodProc)(),
                PR_DWORD flags)
/* Sets the routine used for initializing the state data for a particular
   rendering method. This is used to add new rendering methods to the
   ones existing in Power Render.  */
{
  if (method_number < 256)
    {
     PR_LightMethod[method_number] = MethodProc;
     PR_MethodFlags[method_number] = flags;
    }
}


void PR_InitializeRenderMethods (void)
/* Sets the initial rendering methods array */
{
PR_DWORD i;

  for (i = 0; i < 256; i++)
    PR_RegisterRenderMethod (i, NULL, 0);

  PR_RegisterRenderMethod(1,  L_CFLAT, 0);        // Wireframe
  PR_RegisterRenderMethod(2,  L_CFLAT, 0);        // T_CFLAT
  PR_RegisterRenderMethod(3,  L_FLAT, 0);         // T_FLAT
  PR_RegisterRenderMethod(4,  L_CGOURAUD, 0);     // T_CGOURAUD
  PR_RegisterRenderMethod(5,  L_GOURAUD, 0);      // T_GOURAUD
  PR_RegisterRenderMethod(6,  L_DECAL, 0);        // T_LTEXTURED
  PR_RegisterRenderMethod(7,  L_XDECAL, 1);       // T_LXTEXTURED
  PR_RegisterRenderMethod(8,  L_DECAL, 0);        // T_TEXTURED
  PR_RegisterRenderMethod(9,  L_DECAL, 0);        // T_WTEXTURED
  PR_RegisterRenderMethod(10, L_XDECAL, 1);       // T_XTEXTURED
  PR_RegisterRenderMethod(11, L_XDECAL, 1);       // T_XWTEXTURED
  PR_RegisterRenderMethod(12, L_CFLATTEXT, 0);    // T_LCFLAT_TEXTURED
  PR_RegisterRenderMethod(13, L_XCFLATTEXT, 1);   // T_LXCFLAT_TEXTURED
  PR_RegisterRenderMethod(14, L_CFLATTEXT, 0);    // T_CFLAT_TEXTURED
  PR_RegisterRenderMethod(15, L_CFLATTEXT, 0);    // T_WCFLAT_TEXTURED
  PR_RegisterRenderMethod(16, L_XCFLATTEXT, 1);   // T_XCFLAT_TEXTURED
  PR_RegisterRenderMethod(17, L_XCFLATTEXT, 1);   // T_XWCFLAT_TEXTURED
  PR_RegisterRenderMethod(18, L_FLATTEXT, 0);     // T_FLAT_TEXTURED
  PR_RegisterRenderMethod(19, L_FLATTEXT, 0);     // T_WFLAT_TEXTURED
  PR_RegisterRenderMethod(20, L_XFLATTEXT, 1);    // T_XFLAT_TEXTURED
  PR_RegisterRenderMethod(21, L_XFLATTEXT, 1);    // T_XWFLAT_TEXTURED
  PR_RegisterRenderMethod(22, L_FLATTEXT, 0);     // T_LFLAT_TEXTURED
  PR_RegisterRenderMethod(23, L_XFLATTEXT, 1);    // T_LXFLAT_TEXTURED
  PR_RegisterRenderMethod(24, L_CGOURAUDTEXT, 0); // T_LCGOURAUD_TEXTURED
  PR_RegisterRenderMethod(25, L_XCGOURAUDTEXT, 1);// T_LXCGOURAUD_TEXTURED
  PR_RegisterRenderMethod(26, L_CGOURAUDTEXT, 0); // T_CGOURAUD_TEXTURED8
  PR_RegisterRenderMethod(27, L_CGOURAUDTEXT, 0); // T_WCGOURAUD_TEXTURED8
  PR_RegisterRenderMethod(28, L_XCGOURAUDTEXT, 1);// T_XCGOURAUD_TEXTURED8
  PR_RegisterRenderMethod(29, L_XCGOURAUDTEXT, 1);// T_XWCGOURAUD_TEXTURED8
  PR_RegisterRenderMethod(30, L_GOURAUDTEXT, 0);  // T_LGOURAUD_TEXTURED
  PR_RegisterRenderMethod(31, L_XGOURAUDTEXT, 1); // T_LXGOURAUD_TEXTURED
  PR_RegisterRenderMethod(32, L_GOURAUDTEXT, 0);  // T_GOURAUD_TEXTURED8
  PR_RegisterRenderMethod(33, L_GOURAUDTEXT, 0);  // T_WGOURAUD_TEXTURED8
  PR_RegisterRenderMethod(34, L_XGOURAUDTEXT, 1); // T_XGOURAUD_TEXTURED8
  PR_RegisterRenderMethod(35, L_XGOURAUDTEXT, 1); // T_XWGOURAUD_TEXTURED8
  PR_RegisterRenderMethod(36, L_TRANSTEXT, 1);    // T_LTRANSLUCENT_TEXTURED    
  PR_RegisterRenderMethod(37, L_XTRANSTEXT, 1);   // T_LXTRANSLUCENT_TEXTURED    
  PR_RegisterRenderMethod(38, L_TRANSTEXT, 1);    // T_TRANSLUCENT_TEXTURED    
  PR_RegisterRenderMethod(39, L_TRANSTEXT, 1);    // T_WTRANSLUCENT_TEXTURED    
  PR_RegisterRenderMethod(40, L_XTRANSTEXT, 1);   // T_XTRANSLUCENT_TEXTURED    
  PR_RegisterRenderMethod(41, L_XTRANSTEXT, 1);   // T_XWTRANSLUCENT_TEXTURED    
  PR_RegisterRenderMethod(42, L_CGOURAUD, 0);     // T_PCGOURAUD
  PR_RegisterRenderMethod(43, L_GOURAUD, 0);      // T_PGOURAUD
  PR_RegisterRenderMethod(44, L_DECAL, 0);        // T_PTEXTURED
  PR_RegisterRenderMethod(45, L_DECAL, 0);        // T_PWTEXTURED
  PR_RegisterRenderMethod(46, L_XDECAL, 1);       // T_PXTEXTURED
  PR_RegisterRenderMethod(47, L_XDECAL, 1);       // T_PXWTEXTURED
  PR_RegisterRenderMethod(48, L_CFLATTEXT, 0);    // T_PCFLAT_TEXTURED
  PR_RegisterRenderMethod(49, L_CFLATTEXT, 0);    // T_PWCFLAT_TEXTURED
  PR_RegisterRenderMethod(50, L_XCFLATTEXT, 1);   // T_PXCFLAT_TEXTURED
  PR_RegisterRenderMethod(51, L_XCFLATTEXT, 1);   // T_PXWCFLAT_TEXTURED
  PR_RegisterRenderMethod(52, L_FLATTEXT, 0);     // T_PFLAT_TEXTURED
  PR_RegisterRenderMethod(53, L_FLATTEXT, 0);     // T_PWFLAT_TEXTURED
  PR_RegisterRenderMethod(54, L_XFLATTEXT, 1);    // T_PXFLAT_TEXTURED
  PR_RegisterRenderMethod(55, L_XFLATTEXT, 1);    // T_PXWFLAT_TEXTURED
  PR_RegisterRenderMethod(56, L_CGOURAUDTEXT, 0); // T_PCGOURAUD_TEXTURED
  PR_RegisterRenderMethod(57, L_CGOURAUDTEXT, 0); // T_PWCGOURAUD_TEXTURED
  PR_RegisterRenderMethod(58, L_XCGOURAUDTEXT, 1);// T_PXCGOURAUD_TEXTURED
  PR_RegisterRenderMethod(59, L_XCGOURAUDTEXT, 1);// T_PXWCGOURAUD_TEXTURED
  PR_RegisterRenderMethod(60, L_GOURAUDTEXT, 0);  // T_PGOURAUD_TEXTURED
  PR_RegisterRenderMethod(61, L_GOURAUDTEXT, 0);  // T_PWGOURAUD_TEXTURED
  PR_RegisterRenderMethod(62, L_XGOURAUDTEXT, 1); // T_PXGOURAUD_TEXTURED
  PR_RegisterRenderMethod(63, L_XGOURAUDTEXT, 1); // T_PXWGOURAUD_TEXTURED
  PR_RegisterRenderMethod(64, L_TRANSTEXT, 1);    // T_PTRANSLUCENT_TEXTURED    
  PR_RegisterRenderMethod(65, L_TRANSTEXT, 1);    // T_PWTRANSLUCENT_TEXTURED    
  PR_RegisterRenderMethod(66, L_XTRANSTEXT, 1);   // T_PXTRANSLUCENT_TEXTURED    
  PR_RegisterRenderMethod(67, L_XTRANSTEXT, 1);   // T_PXWTRANSLUCENT_TEXTURED    
  PR_RegisterRenderMethod(68, L_FLAT, 1);         // T_SOURCETRANSFORM
  PR_RegisterRenderMethod(69, L_LIGHTMAPA, 1);    // T_LIGHTMAP_ADD
  PR_RegisterRenderMethod(70, L_LIGHTMAPM, 1);    // T_LIGHTMAP_TIMES
}

