// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Header File Name: asprint.hpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer  
// File Creation Date: 09/18/1997  
// Date Last Modified: 10/22/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

These classes and functions are used to print data to ASCII
text files and format data for various print functions.
*/
// ----------------------------------------------------------- // 
#ifndef __OFPRINT_HPP__
#define __OFPRINT_HPP__

#include <fstream.h> 

// Constants for print functions
const int asPrintCols = 80;      // Columns for portrait print outs
const int asPrintColsLong = 132; // Columns for lanscape print outs
const int asPrintRows = 25;      // Rows for portrait print outs
const int asPrintRowsLong = 25;  // Rows for lanscape print outs

// Control characters
const char asLineFeed = '\n';

// Function prototypes for standalone print functions
void ASPrint(const char *s, ostream &stream, int offset, int pos = 0,
	     const char pad = ' ');
void ASPrint(const char *s, const char filter, ostream &stream, int offset,
	     int pos = 0, const char pad = ' ');
void ASPrint(const char c, ostream &stream, int offset, int pos = 0,
	     const char pad = ' ');
void ASPrint(int val, ostream &stream, int offset, int pos = 0,
	     const char pad = ' ');
void ASPrint(long val, ostream &stream, int offset, int pos = 0,
	     const char pad = ' ');
void ASPrint(double val, ostream &stream, int offset, int pos = 0,
	     const char pad = ' ');

#endif // __OFPRINT_HPP__
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
