// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: btreeprt.cpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 02/12/1997 
// Date Last Modified: 10/08/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

BTree printing functions used to debug the code that works with
the (B)alanced multi-way file-base (T)ree class.
*/
// ----------------------------------------------------------- //   
#include <iostream.h>
#include <string.h>
#include "btreeprt.hpp"
#include "cacstats.hpp"

// Global variables used for displaying tree nodes
int LineCount = 0;

void PrintNode(CachePointer n)
// Prints a single btree node.
{
  int i = 0;
  FAU addr = (__LWORD__)n;
  cout << "Node FAU: " << (__LWORD__)addr << "\t";
  while (i < n->cnt) {
    cout << " <";
    cout << n->entry[i].key;
    cout << ", " << (__LWORD__)n->entry[i].object_address;
    cout << ", " << (__LWORD__)n->entry[i].class_id;
    cout << "> ";
    i++;
  }
  cout << endl;
}

void PrintTree(CachePointer t, Btree *tree)
// Prints the entire tree node by node.
{
  int i;

  // Ensure that the in memory buffers and the file data
  // stay in sync during multiple file access.
  tree->TestTree();

  if ((__LWORD__)t) {
    PrintNode(t);
    int n = t->cnt;
    if(LineCount > DisplayLines) {
      LineCount = 0;
      cout << endl;
      cout << "Press enter to continue >";
      cin.get();
      cout << endl;
    }

    CachePointer p(t);
    LineCount++;
    for(i = -1; i < n; i++) {
      p = t->Branch(i);
        t.Release();
        PrintTree(p, tree);  
    }
  }
}

void ListInOrder(CachePointer t, Btree *tree)
// List the btree data node by node. 
{
  int i = 0;

  // Ensure that the in memory buffers and the file data
  // stay in sync during multiple file access.
  tree->TestTree();

  if ((__LWORD__)t) {
    while (i < t->cnt) {
      cout << t->entry[i].key << endl;
      i++;
      LineCount++;
    }
    if(LineCount > DisplayLines) {
      LineCount = 0;
      cout << endl;
      cout << "Press enter to continue >";
      cin.get();
      cout << endl;
    }

    int n = t->cnt;
    CachePointer p(t);
    for(i = -1; i < n; i++) { 
      if((__LWORD__)p) 
	p = t->Branch(i);
      t.Release(); // Prevent cache from filling up during recursion
      ListInOrder(p, tree);  
    }
  }
}

void BTreeStats(Btree &t)
{
  // Ensure that the in memory buffers and the file data
  // stay in sync during multiple file access.
  t.TestTree();

  cout << endl << "---- Btree Statistics ----" << endl;
  cout << "Tree stats: " << t.GetNumEntries() << " entries, ";
  cout << t.GetNumNodes() << " nodes, " << t    
       << " levels" << endl;
  cout << "Root FAU = " << (__LWORD__)t.GetRoot() << endl;
  Report(*(t.GetCache()), 0);
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
