// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: btreeprt.hpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 02/12/1997 
// Date Last Modified: 10/08/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

BTree printing functions used to debug the code that works with
the (B)alanced multi-way file-base (T)ree class.

Changes:
================================================================
10/08/1998: Modified the PrintTree() function to test the Btree 
before printing it to the console. NOTE: A pointer to the Btree
must be suppiled when calling this function.
Changed by: Doug Gaer

10/08/1998: Modified the ListInOrder() function to test the Btree 
before listing its contents. NOTE: A pointer to the Btree must be
suppiled when calling this function.
Changed by: Doug Gaer

10/08/1998: Modified the BTreeStats() function to test the Btree
before displaying the Btree statistics.
Changed by: Doug Gaer
*/
// ----------------------------------------------------------- //   
#ifndef __BTREEPRT_HPP__
#define __BTREEPRT_HPP__

#include "btree.hpp"

// Global variables used for displaying tree nodes
const int DisplayLines = 10;
extern int LineCount;

// Standalone functions that operate on Cache Pointers.
void PrintNode(CachePointer n); 

// Recursive functions
void PrintTree(CachePointer t, Btree *tree);
void ListInOrder(CachePointer t, Btree *tree);

// Display various Btree statistics.
void BTreeStats(Btree &t);
  
#endif // __BTREEPRT_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
