// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: entrykey.hpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 02/12/1997 
// Date Last Modified: 09/02/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The EntryKey class is used to identify objects in the database
by a unique key name when an index file is used. Each key is
fixed in length by the MAXKEYSIZE constant. An (E)ntry (K)ey
is a key, along with its associated data address and branch
fields.

The Multi-way node (E)ntryKey class and (M)ulti-way (n)ode
classes are used to make up (B)alanced multi-way (T)rees.
Each node in the tree will have a left branch that leads to
all nodes with keys smaller than the smallest key. The right
branches will be paried with a key, each branch leading to all
nodes with keys greater than the given key, but less than the
key to the right. 

Changes:
================================================================
09/02/1998: Modified all the class constructors and overloaded
assignment operators initialize the key member by setting all
bytes to zero before using it.
Changed by: Doug Gaer
================================================================
*/
// ----------------------------------------------------------- //   
#ifndef __ENTRYKEY_HPP__
#define __ENTRYKEY_HPP__

#include "int32.hpp"

// Maximum size of a key including a null byte.
// This will allow 64 bytes (512 bits) per string key.
// NOTE: If the MAXKEYSIZE constant is changed, all the
// VBD index files will have to rebuilt if they used a
// different MAXKEYSIZE value when they were created.
const int MAXKEYSIZE = 64; 

// Multi-way node (E)ntry class 
class EntryKey
{
public:
  EntryKey();
  EntryKey(const char *s);
  EntryKey(const char *s, INT32 oa, INT32 ci);
  EntryKey(const EntryKey &s);
  void operator=(const EntryKey &s);
  void operator=(const char *s);

public:
  void SetStrKey(char *s);
  void SetStrKey(const char *s);
  void SetOA(INT32 oa) { object_address = oa; }
  void SetCID(INT32 cid) { class_id = cid; }
  char *GetStrKey() { return key; }
  const char *GetStrKey() const { return key; }
  INT32 GetOA() { return object_address; }
  INT32 GetOA() const { return object_address; }
  INT32 GetCID() { return class_id; }
  INT32 GetCID() const { return class_id; }
  friend int Compare(const EntryKey &a, const EntryKey &b);
  friend int FullCompare(const EntryKey &a, const EntryKey &b);
  void SetClassID(INT32 id) { class_id = id; }
  void SetObjectAddress(INT32 addr) { object_address = addr; }
  INT32 ClassID() { return class_id; }
  INT32 ObjectAddress() { return object_address; }

public:
  char key[MAXKEYSIZE]; // Unique data key 
  INT32 class_id;       // Class ID number of the object
  INT32 object_address; // Object's address in the database file
  INT32 right;          // Points to right child
};

#endif // __ENTRYKEY_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
