// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: mnode.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 02/12/1997 
// Date Last Modified: 07/24/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The Multi-way node (E)ntryKey class and (M)ulti-way (n)ode
classes are used to make up (B)alanced multi-way (T)rees.
Each node in the tree will have a left branch that leads to
all nodes with keys smaller than the smallest key. The right
branches will be paried with a key, each branch leading to all
nodes with keys greater than the given key, but less than the
key to the right.
*/
// ----------------------------------------------------------- // 
#include <string.h>
#include "mnode.hpp"

INT32 &Mnode::Branch(int posn)
// Returns the branch for the given position. The left
// branch is returned if posn = -1
{
  // NOTE: In order for this version of the Branch() function to
  // work there cannot be any gaps between the left and entry
  // fields in the Mnode class. To bypass this rule explicitly
  // test for -1 and return the left branch.

  return entry[posn].right;
}

INT32 &Mnode::GetBranchs(int posn)
// Return the left branch if posn = -1
{
  if(posn == -1) return left;
  return entry[posn].right;
}

int Mnode::Search(const EntryKey &e, int &posn)
// Tries to match e's key with the keys in the entries
// of this node. Returns -1 if e's key is less than all
// keys in the node, returns 0 if there was a match, 
// return 1 if e's key is greater than all keys in the 
// node. Passes back posn of matching entry if any, or 
// the posn of the entry containing the appropriate branch
// to keep searching down.
{
  posn = cnt-1;

  while(posn >= 0) {
    int rv = Compare(e, entry[posn]);
    if (rv > 0) return 1;
    if (rv == 0) return 0;
    posn--;
  }
  return -1;
}

int Mnode::FullSearch(const EntryKey &e, int &posn)
// Like the first Search(), except it uses FullCompare().
{
  posn = cnt-1;

  while(posn >= 0) {
    int rv = FullCompare(e, entry[posn]);
    if (rv > 0) return 1;
    if (rv == 0) return 0;
    posn--;
  }
  return -1;
}

void Mnode::Split(Mnode &b, int split_posn)
// Moves right half of this node at split_posn into empty b.
// Assumes split_posn is in range.
{
  b.cnt = cnt - split_posn; // Compute how much to move
  memmove(b.entry, entry+split_posn, (b.cnt)*sizeof(EntryKey));
  cnt = split_posn;
}

void Mnode::InsEntryKey(EntryKey &e, int posn)
// Inserts entry e into node at position posn. Assumes
// there is room and assumes posn <= cnt;
{
  memmove(entry+posn+1, entry+posn, (cnt-posn)*sizeof(EntryKey));
  entry[posn] = e;
  cnt++;
}

void Mnode::Cat(Mnode &n)
// Adds all entries of node n to the end of this node.
// Assumes there is enough room.
{
  for(int i = 0; i<n.cnt; i++) entry[cnt++] = n.entry[i];
}

void Mnode::DelEntryKey(int posn)
// Deletes the entry at position posn. Assumes posn is in range.
{
  cnt--;
  memmove(entry+posn, entry+posn+1, (cnt-posn)*sizeof(EntryKey));
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
