#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program
# C/C++ Compiler Used: HP C++ A.10.24  compiled for HP-UX 10.20 
# Produced By: Doug Gaer      ^^^^^^^
# File Creation Date: 03/21/1997 
# Date Last Modified: 10/15/1998 
#
# NOTE: If using the template classes this program will not 
# compile under HP C++ A.10.09. The template version of the 
# Bucket class uses a template parameter as base class, which 
# was not allowed in this version of HP C++. To get the current 
# version number enter the following command:
# 
# % what /opt/CC/bin/CC
# ***************************************************************
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	v    -- Echo compilation
#	g    -- Enable debugging
#	+w   -- Turn on all warnings
#	+a1  -- Allow ANSI C automatic aggregate initialization	
#	-pta -- Instantiate entire template class
#       +eh  -- Enable C++ exception handling
# --------------------------------------------------------------- 
SHELL = /bin/sh

# Define a name for the executable
PROJECT = testprog

# Setup additional paths for includes and source code
BASE_PATH = ../base/
CACHE_PATH = ../../cache/base/
EHANDLER_PATH = ../../ehandler/base/
DTYPES_PATH = ../../dtypes/base/
VBDFILE_PATH = ../../vbdfile/base/
REFCOUNT_PATH = ../../refcount/base/
PLACENEW_PATH = ../../placenew/base/
USTRING_PATH = ../../ustring/base/
STRUTIL_PATH = ../../strutil/base/
CRC32_PATH = ../../crc32/base/

ADD_INC_PATHS = -I../base -I../../ehandler/base -I../../dtypes/base \
-I../../vbdfile/base -I../../pod/base -I../../refcount/base \
-I../../cache/base -I../../placenew/base -I../../ustring/base \
-I../../strutil/base -I../../crc32/base

# Alloaction method used to reclaim deleted blocks
DEF_VB_ALLOC = -D__RECLAIM_BEST_FIT__ 
#DEF_VB_ALLOC = -D__RECLAIM_FIRST_FIT__ 

# Use this DEFMACS macro to compile without using template classes
DEFMACS = -D__NOT_USING_TEMPLATE_CLASS__ -D__BTREE_MNODE__ -D__CONSOLE__ \
-D__USE_VBDREFCOUNT__ -D__UNIX__ $(DEF_VB_ALLOC) # -DCPP_EXCEPTIONS

# Enable to use the template classes
# DEFMACS = -D__CONSOLE__ -D__UNIX__ $(DEF_VB_ALLOC) # -DCPP_EXCEPTIONS

# Define macros for compiler and linker
CC = cc
CPP = CC
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -v -g +a1 -pta +eh $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
LFLAGS =  

# Build dependency rules
# ===============================================================
VBDSTATS_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp $(VBDFILE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(DTYPES_PATH)uint32.hpp \
	$(CRC32_PATH)crc32.hpp

CRC32_DEP = $(CRC32_PATH)crc32.hpp $(CRC32_PATH)crc32tab.hpp

UINT32_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)uint32.hpp

BUCKET_DEP = $(CACHE_PATH)bucket.hpp $(CACHE_PATH)cacheb.hpp \
	$(CACHE_PATH)cactype.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(VBDFILE_PATH)vbdfile.hpp $(BASE_PATH)mnode.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(BASE_PATH)mnode.hpp \
	$(DTYPES_PATH)uint32.hpp

CACHE_DEP = $(CACHE_PATH)bucketb.hpp $(CACHE_PATH)cacheb.hpp \
	$(CACHE_PATH)cactype.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(VBDFILE_PATH)vbdfile.hpp $(BASE_PATH)mnode.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(BASE_PATH)mnode.hpp \
	$(DTYPES_PATH)uint32.hpp	

CACHEB_DEP = $(CACHE_PATH)bucketb.hpp $(CACHE_PATH)cacheb.hpp \
	$(EHANDLER_PATH)ehandler.hpp $(VBDFILE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(DTYPES_PATH)int32.hpp \
	$(DTYPES_PATH)dtypes.hpp $(DTYPES_PATH)uint32.hpp

CHPTRB_DEP = $(CACHE_PATH)bucket.hpp $(CACHE_PATH)bucketb.hpp \
	$(CACHE_PATH)cache.hpp $(CACHE_PATH)cacheb.hpp \
	$(CACHE_PATH)chptrb.hpp $(CACHE_PATH)cactype.hpp\
	$(EHANDLER_PATH)ehandler.hpp $(VBDFILE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(DTYPES_PATH)int32.hpp \
	$(DTYPES_PATH)dtypes.hpp $(DTYPES_PATH)uint32.hpp

BTREE_DEP = $(CACHE_PATH)bucket.hpp $(CACHE_PATH)bucketb.hpp \
	$(CACHE_PATH)cache.hpp $(CACHE_PATH)cacheb.hpp \
	$(CACHE_PATH)chptrb.hpp $(CACHE_PATH)cactype.hpp\
	$(CACHE_PATH)cacheptr.hpp $(BASE_PATH)btree.hpp \
	$(EHANDLER_PATH)ehandler.hpp $(VBDFILE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(PLACENEW_PATH)placenew.hpp \
	$(DTYPES_PATH)int32.hpp  $(DTYPES_PATH)dtypes.hpp \
	$(BASE_PATH)mnode.hpp $(BASE_PATH)entrykey.hpp \
	$(DTYPES_PATH)uint32.hpp

BTREEPRT_DEP = $(CACHE_PATH)bucket.hpp $(CACHE_PATH)bucketb.hpp \
	$(CACHE_PATH)cache.hpp $(CACHE_PATH)cacheb.hpp \
	$(CACHE_PATH)chptrb.hpp $(CACHE_PATH)cactype.hpp\
	$(CACHE_PATH)cacheptr.hpp $(BASE_PATH)btree.hpp \
	$(EHANDLER_PATH)ehandler.hpp $(VBDFILE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(PLACENEW_PATH)placenew.hpp \
	$(DTYPES_PATH)int32.hpp  $(DTYPES_PATH)dtypes.hpp \
	$(BASE_PATH)mnode.hpp $(BASE_PATH)btreeprt.hpp \
	$(BASE_PATH)entrykey.hpp $(DTYPES_PATH)uint32.hpp

BTWALK_DEP = $(CACHE_PATH)bucket.hpp $(CACHE_PATH)bucketb.hpp \
	$(CACHE_PATH)cache.hpp $(CACHE_PATH)cacheb.hpp \
	$(CACHE_PATH)chptrb.hpp $(CACHE_PATH)cactype.hpp\
	$(CACHE_PATH)cacheptr.hpp $(BASE_PATH)btree.hpp \
	$(EHANDLER_PATH)ehandler.hpp $(VBDFILE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(PLACENEW_PATH)placenew.hpp \
	$(DTYPES_PATH)int32.hpp  $(DTYPES_PATH)dtypes.hpp \
	$(BASE_PATH)mnode.hpp $(BASE_PATH)btreeprt.hpp \
	$(BASE_PATH)entrykey.hpp $(USTRING_PATH)ustring.hpp \
	$(STRUTIL_PATH)strutil.hpp $(DTYPES_PATH)uint32.hpp

CACSTATS_DEP = $(CACHE_PATH)bucketb.hpp $(CACHE_PATH)cacheb.hpp \
	$(EHANDLER_PATH)ehandler.hpp $(VBDFILE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(DTYPES_PATH)int32.hpp \
	$(DTYPES_PATH)dtypes.hpp $(CACHE_PATH)cacstats.hpp \
	$(DTYPES_PATH)uint32.hpp

ENTRYKEY_DEP = $(BASE_PATH)entrykey.hpp $(DTYPES_PATH)dtypes.hpp \
	$(EHANDLER_PATH)ehandler.hpp $(DTYPES_PATH)int32.hpp

MNODE_DEP = $(BASE_PATH)mnode.hpp $(DTYPES_PATH)dtypes.hpp \
	$(EHANDLER_PATH)ehandler.hpp $(DTYPES_PATH)int32.hpp \
	$(BASE_PATH)entrykey.hpp

EHANDLER_DEP = $(EHANDLER_PATH)ehandler.hpp

INT32_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp

VBDFILE_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp $(VBDFILE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(DTYPES_PATH)uint32.hpp \
	$(CRC32_PATH)crc32.hpp

VBDREF_DEP = $(VBDFILE_PATH)vbdfile.hpp \
	$(VBDFILE_PATH)vbdref.hpp $(REFCOUNT_PATH)refcount.hpp

USTRING_DEP = $(USTRING_PATH)ustring.hpp

STRUTIL_DEP = $(STRUTIL_PATH)strutil.hpp

TESTPROG_DEP = $(CACHE_PATH)bucket.hpp $(CACHE_PATH)bucketb.hpp \
	$(CACHE_PATH)cache.hpp $(CACHE_PATH)cacheb.hpp \
	$(CACHE_PATH)chptrb.hpp $(CACHE_PATH)cacheptr.hpp \
	$(CACHE_PATH)cactype.hpp $(BASE_PATH)btree.hpp \
	$(EHANDLER_PATH)ehandler.hpp $(DTYPES_PATH)int32.hpp \
        $(VBDFILE_PATH)vbdfile.hpp $(REFCOUNT_PATH)refcount.hpp \
	$(PLACENEW_PATH)placenew.hpp $(BASE_PATH)mnode.hpp \
	$(BASE_PATH)btreeprt.hpp $(BASE_PATH)entrykey.hpp \
	$(BASE_PATH)btwalk.hpp $(CACHE_PATH)cacstats.hpp \
	$(USTRING_PATH)ustring.hpp $(STRUTIL_PATH)strutil.hpp \
	$(DTYPES_PATH)uint32.hpp $(VBDFILE_PATH)vbdstats.hpp
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

vbdstats.o:    $(VBDFILE_PATH)vbdstats.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(VBDFILE_PATH)vbdstats.cpp

uint32.o:	$(DTYPES_PATH)uint32.cpp $(UINT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)uint32.cpp

crc32.o:	$(CRC32_PATH)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CRC32_PATH)crc32.cpp

bucket.o:	$(CACHE_PATH)bucket.cpp $(BUCKET_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)bucket.cpp

cache.o:	$(CACHE_PATH)cache.cpp $(CACHE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)cache.cpp

cacheb.o:	$(CACHE_PATH)cacheb.cpp $(CACHEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)cacheb.cpp

chptrb.o:	$(CACHE_PATH)chptrb.cpp $(CHPTRB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)chptrb.cpp

cacstats.o:	$(CACHE_PATH)cacstats.cpp $(CACSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)cacstats.cpp

mnode.o:	$(BASE_PATH)mnode.cpp $(MNODE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)mnode.cpp

entrykey.o:	$(BASE_PATH)entrykey.cpp $(ENTRYKEY_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)entrykey.cpp

btree.o:	$(BASE_PATH)btree.cpp $(BTREE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)btree.cpp

btreeprt.o:	$(BASE_PATH)btreeprt.cpp $(BTREEPRT_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)btreeprt.cpp

btwalk.o:	$(BASE_PATH)btwalk.cpp $(BTWALK_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)btwalk.cpp

ehandler.o:	$(EHANDLER_PATH)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(EHANDLER_PATH)ehandler.cpp

int32.o:	$(DTYPES_PATH)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)int32.cpp

vbdfile.o:    $(VBDFILE_PATH)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(VBDFILE_PATH)vbdfile.cpp

vbdref.o:	$(VBDFILE_PATH)vbdref.cpp $(VBDREF_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(VBDFILE_PATH)vbdref.cpp

ustring.o:	$(USTRING_PATH)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(USTRING_PATH)ustring.cpp 

strutil.o:	$(STRUTIL_PATH)strutil.cpp $(STRUTIL_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(STRUTIL_PATH)strutil.cpp 

testprog.o:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

# Make the executable
OBJS = cacheb.o chptrb.o btree.o ehandler.o vbdfile.o \
	testprog.o mnode.o int32.o bucket.o cache.o \
	vbdref.o entrykey.o btreeprt.o cacstats.o \
	btwalk.o strutil.o ustring.o crc32.o uint32.o \
	vbdstats.o

$(PROJECT):	$(OBJS)
	$(CPP) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) 
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)

	echo Removing template repository from working directory...
	rm -r -f ptrepository

	echo Removing any test files created by program
	rm -f *.btx
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
