// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 02/12/1997 
// Date Last Modified: 10/15/1998
// Copyright (c) 1997 Dougas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This is a test program for the (B)alanced multi-way file-base
(T)ree class. This program is used to create an index file,
which contains key indexes. 

The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include "btree.hpp"
#include "btwalk.hpp"
#include "btreeprt.hpp"
#include "vbdstats.hpp"

void pause()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

int main()
{
  EntryKey e;
  int cache_size, status, i;

  cache_size = 15;

  // (B)alanced multi-way file-base (T)ree (I)ndex file extention
 const char *fname = "testfile.btx";
  
  cout << "Making BTree index file with cache size of: "
       << cache_size << endl;
  cout << endl;
  
  VBDFilePtr f(new VBDFile);
  Btree btx(cache_size);
  f->Create(fname, sizeof(BtreeHeader));
  btx.Connect(f, 1);

  char *aa = "DOG";
  char *bb = "CAT";
  char *cc = "FISH";
  char *dd = "MOUSE";
  char *ee = "BIRD";
  char *ff = "PIG";
  char *gg = "HORSE";
  char *hh = "LION";
  char *ii = "SNAKE";
  char *jj = "COW";
  char *kk = "ARMADILLO";
  char *ll = "GROUPER";
  char *mm = "RAT";
  char *nn = "MONKEY";
  char *oo = "ZEBRA";
  char *pp = "STARFISH";
  char *qq = "LIZARD";
  char *rr = "CRAB";
  char *ss = "SNAIL";
  char *tt = "GORILLA";
  char *uu = "LOBSTER";
  char *vv = "TURKEY";
  char *ww = "BEETLE";
  char *xx = "SHARK";
  char *yy = "CLAM";
  char *zz = "OYSTER";
    
  const int NKEYS = 26;
  char *keys[NKEYS] = { aa, bb, cc, dd, ee, ff, gg, hh, ii, jj,
			kk, ll, mm, nn, oo, pp, qq, rr, ss, tt,
                        uu, vv, ww, xx, yy, zz};
  char exists[NKEYS];

  LineCount = 0;
  for(i = 0; i < NKEYS; i++) {
    status = btx.Add(keys[i]);
    LineCount++;
    if (status != 1) {
      cout << endl << "Problem adding " << keys[i] << " - " << i << endl;
      Error->SignalException(EHandler::AssertError);      
    }
    else {
      if(LineCount > DisplayLines) {
	pause();
	LineCount = 0;
      }
      cout << "Adding " << keys[i] << endl;
    }
    exists[i] = 1;
  }
  LineCount = 0;
  cout << endl << "Indexing is complete" << endl;
  BTreeStats(btx);

  pause();

  VBDStats(f);
  
  pause();

  cout << "Walking through the btree..." << endl;
  BtreeWalk(btx.GetRoot(), PrintNode, &btx);
  
  pause();

  cout << "Listing the tree contents..." << endl;
  pause();
  LineCount = 0;
  ListInOrder(btx.GetRoot(), &btx);
  pause();

  cout << "Deleting all entries..." << endl;
  for(i = 0; i < NKEYS; i++) {
    if(btx.Remove(keys[i]) != 1) {
      cout << endl << "Problem removing " << keys[i] << " - " << i << endl;
      Error->SignalException(EHandler::AssertError);
    }
    exists[i] = 0;
  }

  BTreeStats(btx);

  pause();

  cout << "Printing the tree..." << endl;
  LineCount = 0;
  PrintTree(btx.GetRoot(), &btx);

  pause();
  
  cout << "Checking static consistency..." << endl;
  pause();
  for(i = 0; i < NKEYS; i++) {
    cout << i;
    e = keys[i];
     status = btx.FullSearch(e);
     if (status == 1) {
       cout << " found" << '\t'; 
       if (exists[i]) {
	 cout << "OK";
       }
       else {
	 cout << endl << "Found " << keys[i] << " - " << i << endl;
	 Error->SignalException(EHandler::AssertError);
       }
     }
     else {
       cout << " not found" << '\t';
        if (exists[i]) {
	  cout << endl << "Did not find " << keys[i] << " - " << i << endl;
	  Error->SignalException(EHandler::AssertError);
        }
        else cout << "OK";
     }
     cout << endl;
  }

  pause();

  cout << "Adding deleted entries back..." << endl;
  for (i = 0; i < NKEYS; i++) {
      if (!exists[i]) {
         status = btx.Add(keys[i]); 
         if (status != 1) {
	   cout << endl << "Problem adding " << keys[i] << " - " <<  i << endl;
            Error->SignalException(EHandler::AssertError);
         }
         exists[i] = 1;
      }
  }
 
  pause();

  cout << "Verifying insertions again..." << endl;
  pause();
  for (i = 0; i < NKEYS; i++) {
      e = keys[i];
      status = btx.FullSearch(e);
      if (status != 1 && exists[i]) {
	cout << endl << "Problem finding " << keys[i] << " - " << i << endl;
         Error->SignalException(EHandler::AssertError);
      }
      else
	cout << i << " - Found " << keys[i] << endl;
  }

  pause();

  cout << "Checking dynamic consistency by deleting all entries..." << endl;
  pause();
  for(i = 0; i < NKEYS; i++) {
    cout << i;
    status = btx.Remove(keys[i]);
    if (status == 1) {
      cout << " deleted" << '\t';
      if (exists[i]) {
	cout << "OK";
      }
      else {
	cout << endl << "Found " << keys[i] << " - " << i << endl;
        Error->SignalException(EHandler::AssertError);
      }
    }
    else {
      cout << "not found" << '\t';
      if (exists[i]) {
	cout << endl << "Problem finding " << keys[i] << " - " << i << endl;
        Error->SignalException(EHandler::AssertError);
      }
      else cout << "OK";
    }
    cout << endl;
  }
  BTreeStats(btx);

  cout << endl << endl << "---> Test Succeeded <---" << endl;
  cout << "     Flusing buffers ..." << endl;

  pause();

  VBDStats(f);
  
  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
