// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: bucket.hpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer    
// File Creation Date: 02/07/1997  
// Date Last Modified: 09/22/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The cache bucket class is derived from the Bucketb class,
creating a family of classes specific to the data type stored.
Both of the cache bucket classes are used to keep addresses
and memory buffers paired together, to prevent a file-based
object's address from being associated with the wrong memory
buffer.
*/
// ----------------------------------------------------------- //   
#ifndef __BUCKET_HPP__
#define __BUCKET_HPP__

#include "bucketb.hpp"
#include "cacheb.hpp"
#include "vbdfile.hpp"

// NOTE: To avoid portability problems with template classes, enable
// the __NOT_USING_TEMPLATE_CLASS__ macro and directly code the
// Bucket class, Cache class, and the CachePtr class for the data
// type that will be used.

// Default to using template class
#ifndef __NOT_USING_TEMPLATE_CLASS__
#define __USING_TEMPLATE_CLASS__
#endif

#ifdef __USING_TEMPLATE_CLASS__
// Cache (B)ucket class
template<class TYPE>
class Bucket : public Bucketb, public TYPE
// Using template parameter TYPE as a base class to allow buckets to
// act like tree nodes. The TYPE base class links the cache and the
// tree nodes together via multiple inheritance.
{
public:
  Bucket() { } // Call Bucketb and TYPE constructors

public:
  virtual void Fetch(VBDFile &f);
  virtual void Store(VBDFile &f);
};

template<class TYPE>
void Bucket<TYPE>::Fetch(VBDFile &f)
{
  // Fetch only the TYPE portion of the bucket
  f.Read((TYPE *)this, sizeof(TYPE), Address);
  Dirty = 0;
}

template<class TYPE>
void Bucket<TYPE>::Store(VBDFile &f)
{
  // Store only the TYPE portion of the bucket
  f.Write((TYPE *)this, sizeof(TYPE), Address);
  Dirty = 0;
}
#endif // __USING_TEMPLATE_CLASS__

#ifdef __NOT_USING_TEMPLATE_CLASS__
#include "cactype.hpp"  // General definition of the bucket data (T)ype

// Cache (B)ucket class
class Bucket : public Bucketb, public TYPE
// The TYPE base class links the cache and the tree nodes
// together via multiple inheritance. Using TYPE as a base
// class to allows buckets to act like tree nodes.
{
public:
  Bucket() { } // Call Bucketb and TYPE constructors

public:
  virtual void Fetch(VBDFile &f);
  virtual void Store(VBDFile &f);
};
#endif //  __NOT_USING_TEMPLATE_CLASS__

#endif // __BUCKET_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
