// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: cache.hpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 02/07/1997  
// Date Last Modified: 08/05/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The Cache class is derived from the Cacheb class. It adds two
functions to handle the allocation and de-allocation of buckets.
The cache is used to handle requests for file-based objects. The
cache must determine whether an object is already loaded. If the
object is not loaded the cache reserves a bucket and loads the
object into memory. This cache design uses cache pointers to
reference cache buckets directly, with each cache pointer being
initialized after the bucket is reserved. The least-recently
reserved cache bucket is overwritten when the cache fills up.
*/
// ----------------------------------------------------------- //   
#ifndef __CACHE_HPP__
#define __CACHE_HPP__

#include "bucket.hpp"

// NOTE: To avoid portability problems with template classes, enable
// the __NOT_USING_TEMPLATE_CLASS__ macro and directly code the
// Bucket class, Cache class, and the CachePtr class for the data
// type that will be used.

// Default to using template class
#ifndef __NOT_USING_TEMPLATE_CLASS__
#define __USING_TEMPLATE_CLASS__
#endif

#ifdef __USING_TEMPLATE_CLASS__
// Cache class
template<class TYPE>
class Cache : public Cacheb
{
public:
  Cache(int n);
  virtual ~Cache();

protected:
  Bucket<TYPE> *buckets;
};

template<class TYPE>
Cache<TYPE>::
Cache(int n) : Cacheb(buckets = new Bucket<TYPE>[n], n, sizeof(Bucket<TYPE>))
// Buckets are stored in an array and organized as a circular doubly-linked
// list by the Cacheb class.
{

}

template<class TYPE>
Cache<TYPE>::~Cache()
{
  if (fptr) Flush(); Disconnect();
  delete[] buckets;
}
#endif // __USING_TEMPLATE_CLASS__

#ifdef __NOT_USING_TEMPLATE_CLASS__
// (C)ache class
class Cache : public Cacheb
{
public:
  Cache(int n);
  virtual ~Cache();

protected:
  Bucket *buckets;
};
#endif //  __NOT_USING_TEMPLATE_CLASS__

#endif // __CACHE_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
