// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: cacheptr.hpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 02/07/1997  
// Date Last Modified: 08/05/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

Cache pointers are used to work in conjunction with the
reference counted cache buckets. Each cache pointer stores the
file address of the object being poined to, a pointer to the
bucket containing the memory buffer of the object, and a pointer
to the cache the cache pointer is connected to.
*/
// ----------------------------------------------------------- //   
#ifndef __CACHEPTR_HPP__
#define __CACHEPTR_HPP__

#include "chptrb.hpp"
#include "cache.hpp"
#include "placenew.hpp"

// NOTE: To avoid portability problems with template classes, enable
// the __NOT_USING_TEMPLATE_CLASS__ macro and directly code the
// Bucket class, Cache class, and the CachePtr class for the data
// type that will be used.

// Default to using template class
#ifndef __NOT_USING_TEMPLATE_CLASS__
#define __USING_TEMPLATE_CLASS__
#endif

#ifdef __USING_TEMPLATE_CLASS__
// (C)ache (P)ointer class
template<class TYPE>
class CachePtr : public CachePtrb
{
public:
  CachePtr(Cache<TYPE> &c, FAU p = 0) : CachePtrb(c, p) { }
  CachePtr(const CachePtr<TYPE> &c) : CachePtrb(c) { }
  void operator=(const CachePtr<TYPE> &c) { Copy(c); }
  void operator=(__LWORD__ p) { Release(); Address = p; }

public:
  void Delete() { CachePtrb::Delete(sizeof(TYPE)); }

  Bucket<TYPE> &operator*() {
    if(!bound) Bind(); return *(Bucket<TYPE> *)bkt; }

  Bucket<TYPE> *operator->() {
    if (!bound) Bind(); return (Bucket<TYPE> *)bkt; }

  friend void *operator new(size_t n, CachePtr<TYPE> &cp, __LWORD__ p = 0) 
  // Allocates a new object to reside at address p in the file.
  // If p is non-zero, the object is presumed to already
  // allocated. The allocation takes place by calling Alloc(),
  // which not only allocates the object on disk, but also
  // reserves a cache bucket for it. A Bucketb pointer to this
  // bucket is returned by Alloc(), which is typecast as a
  // Bucket<TYPE> pointer. Then a typecast to a TYPE pointer,
  // retrieves a pointer to the bucket's data. The pointer is
  // returned, and is passed to the associated TYPE constructor
  // as the 'this' pointer. 
  {
    return (TYPE *)((Bucket<TYPE> *)(cp.Alloc(n, p))); 
  }
};
#endif // __USING_TEMPLATE_CLASS__

#ifdef __NOT_USING_TEMPLATE_CLASS__
// (C)ache (P)ointer class
class CachePtr : public CachePtrb
{
public:
  CachePtr(Cache &c, FAU p = 0) : CachePtrb(c, p) { }
  CachePtr(const CachePtr &c) : CachePtrb(c) { }
  void operator=(const CachePtr &c) { Copy(c); }
  void operator=(__LWORD__ p) { Release(); Address = p; }

public:
  void Delete() { CachePtrb::Delete(sizeof(TYPE)); }

  Bucket &operator*() {
    if(!bound) Bind(); return *(Bucket *)bkt; }

  Bucket *operator->() {
    if (!bound) Bind(); return (Bucket *)bkt; }

  friend void *operator new(size_t n, CachePtr &cp, __LWORD__ p = 0) 
  // Allocates a new object to reside at address p in the file.
  // If p is non-zero, the object is presumed to already
  // allocated. The allocation takes place by calling Alloc(),
  // which not only allocates the object on disk, but also
  // reserves a cache bucket for it. A Bucketb pointer to this
  // bucket is returned by Alloc(), which is typecast as a
  // Bucket pointer. Then a typecast to a TYPE pointer,
  // retrieves a pointer to the bucket's data. The pointer is
  // returned, and is passed to the associated TYPE constructor
  // as the 'this' pointer. 
  {
    return (TYPE *)((Bucket *)(cp.Alloc(n, p))); 
  }
};
#endif //  __NOT_USING_TEMPLATE_CLASS__

#endif // __CACHEPTR_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
