// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: chptrb.hpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 02/07/1997  
// Date Last Modified: 09/01/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The CachePtrb class is used as a data indepentent base class for
the CachePtr class. Cache pointers are used to work in conjunction
with the reference counted cache buckets. Each cache pointer stores
the file address of the object being poined to, a pointer to the
bucket containing the memory buffer of the object, and a pointer
to the cache the cache pointer is connected to.

Changes:
================================================================
09/02/1998: The Delete() function now calls the VBDFile::Remove()
function instead of the VBDFile::Delete() function to de-allocate
file data pointed to by the cache pointer.
Changed by: Doug Gaer
================================================================
*/
// ----------------------------------------------------------- //   
#ifndef __CHPTRB_HPP__
#define __CHPTRB_HPP__

#include <stddef.h>
#include "int32.hpp"

// This typedef is defined in the vbdfile.hpp file
#ifndef FAU
typedef INT32 FAU; // (F)ile (A)ddress (U)nit, physical file address type
#endif

class Bucketb; class Cacheb; // Forward class declarations

// Data independent (C)ache (P)ointer (b)ase class
class CachePtrb
{
public:
  ~CachePtrb() { Release(); }

protected:
  CachePtrb(Cacheb &c, FAU p);
  CachePtrb(const CachePtrb &c);

private:
  void operator=(const CachePtrb &c) { }; // Disallowed

public:
  void Grab() { if (!bound) Bind(); }
  void Release();
  void NotifyUseOf();
  operator __LWORD__() const { return Address; }

protected:
  void Copy(const CachePtrb &c);
  Bucketb *Alloc(size_t n, FAU p=0);
  void Delete(unsigned n);
  void Bind();

protected:
  FAU Address;   // File address of bucket data
  Bucketb *bkt;  // Pointer to bucket in the cache
  Cacheb *cache; // Pointer to the cache being used
  char bound;    // True if pointer is bound to a bucket
};

#endif // __CHPTRB_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
