// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 02/12/1997 
// Date Last Modified: 10/09/1998
// Copyright (c) 1997 Dougas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This is a test program for the cache classes.

The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <string.h>
#include "vbdfile.hpp"
#include "cacheptr.hpp"
#include "cacstats.hpp"

const int key_size = 16;
const int cache_size = 3;

// A simple node class
class node
{
public:
  node() { key_init(); id = 0; prev = 0; }
  node(char *s) { key_init(); if(s) strcpy(key, s); prev = 0; }
  node(char *s, int i) { key_init(); if(s) strcpy(key, s); id = i; prev = 0; }
  
public:
  void key_init() { for(int i = 0; i < key_size; i++) key[i] = 0; id = 0; }

public:
  UINT32 id;
  FAU prev;
  char key[key_size];
};

// Cache pointers are used to access the reference counted cache
// bucketsd and allow file-based objects to be read automatically.
// NOTE: A cache pointer must be told when to write an object to
// disk after the bucket has been modifed.
typedef CachePtr<node> CachePointer; 

int main()
{
  VBDFilePtr f(new VBDFile);
  const char *FName = "testfile.vbd";
  int exists;
  FAU addr, head, prev = 0;
  
  cout << endl;
  cout << "Simple demo of the cache classes." << endl;
  cout << endl;
  
  if(!VBDFile::Exists(FName)) {
    cout << "Creating new file..." << endl;
    // Create a new file with a static data area of four bytes
    f->Create(FName, sizeof(FAU));
    exists = 0;
  }
  else {
    cout << "Opening existing file..." << endl;
    f->Open(FName);
    exists = 1;
  }
 
  Cache<node> c(cache_size); // Setup a cache of buckets
  c.Connect(f);
  CachePointer p(c);
  
  if(!exists) {
    new(p) node("DOG");
    cout << "Constructing new node at file address " << (__LWORD__)p << endl;
    p->id = (__LWORD__)p; // Set the node's id member
    p->prev = prev;       // Set the address to the previous node 
    p->SetDirty();        // Tell the cache the bucket has been modified

    // Record a pointer to the head of the list in the static data area
    head = prev = (__LWORD__)p;
    f->Write(&head, sizeof(head), sizeof(FileHeader));

    addr = f->Alloc(sizeof(node));
    cout << "Constructing new node at pre-allocated address "
	 << (__LWORD__)addr << endl;
    new(p, addr) node("CAT", addr);
    p->prev = prev;  // Set the address to the previous node 
    p->SetDirty(*f); // Testing write-through cache

    // Update the header after adding a new node
    head = prev = (__LWORD__)p;
    f->Write(&head, sizeof(head), sizeof(FileHeader));

    new(p) node("MOUSE");
    cout << "Constructing new node at file address " << (__LWORD__)p << endl;
    p->SetDirty();        

    cout << "Deleting new node at file address " << (__LWORD__)p << endl;
    cout << endl;
    p.Delete();
  }
  else {
    cout << "Reading the objects from disk using cache pointers." << endl;
    f->Read(&head, sizeof(head), sizeof(FileHeader));
    p = head; 

     while((__LWORD__)p) {
       cout << endl;
       cout << "Object key = " << p->key << endl;
       cout << "Object ID  = " << p->id << endl;
       cout << "Previous   = " << p->prev << endl;
       cout << endl;
       p = p->prev;
     } 
  }

  cout << "Displaying cache statistics." << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
  Report(c, 1);

  p.Release();    // Must release the cache pointer before clearing cache
  c.Disconnect(); // Disconnect the cache and flush all the buckets
  f->Close();     // Flush all the file buffers
  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
