// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: cdate.cpp 
// C++ Compiler Used: Microsoft visual C/C++ version 4.0 
// Produced By: Doug Gaer   
// File Creation Date: 09/21/1997 
// Date Last Modified: 06/10/1998 
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The CDate class is used turn a date string into into concrete
data type.
*/
// ----------------------------------------------------------- // 
#include "string.h"
#include "stdio.h"
#include "cdate.hpp"

// String lenght for date strings
const int MaxStrLen = 25;

CDate::CDate(const CDate& ob)
{
  Month = ob.Month;
  Day = ob.Day;
  Year = ob.Year;
}

CDate& CDate::operator=(const CDate& ob)
{
  Month = ob.Month;
  Day = ob.Day;
  Year = ob.Year;
  return *this;
}

char *CDate::c_str()
// Returns null terminated date string
{
  const int MaxStrLen = 25;
  char date_str[MaxStrLen];
  sprintf(date_str, "%u/%u/%u", (unsigned)Month,(unsigned)Day,(unsigned)Year);
  int len = strlen(date_str);
  char *buf = new char[len];
  buf[len] = '\0';
  memmove(buf, date_str, len);
  return buf;
}

const char *CDate::c_str() const
// Returns null terminated date string
{
  const int MaxStrLen = 25;
  char date_str[MaxStrLen];
  sprintf(date_str, "%u/%u/%u", (unsigned)Month,(unsigned)Day,(unsigned)Year);
  int len = strlen(date_str);
  char *buf = new char[len];
  buf[len] = '\0';
  memmove(buf, date_str, len);
  return buf;
}

char *CDate::month_c_str()
// Returns null terminated date string
{
  char date_str[MaxStrLen];
  sprintf(date_str, "%u", (unsigned)Month);
  int len = strlen(date_str);
  char *buf = new char[len];
  buf[len] = '\0';
  memmove(buf, date_str, len);
  return buf;
}

const char *CDate::month_c_str() const
// Returns null terminated date string
{
  char date_str[MaxStrLen];
  sprintf(date_str, "%u", (unsigned)Month);
  int len = strlen(date_str);
  char *buf = new char[len];
  buf[len] = '\0';
  memmove(buf, date_str, len);
  return buf;
}

char *CDate::day_c_str()
// Returns null terminated date string
{
  char date_str[MaxStrLen];
  sprintf(date_str, "%u", (unsigned)Day);
  int len = strlen(date_str);
  char *buf = new char[len];
  buf[len] = '\0';
  memmove(buf, date_str, len);
  return buf;
}

const char *CDate::day_c_str() const
// Returns null terminated date string
{
  char date_str[MaxStrLen];
  sprintf(date_str, "%u", (unsigned)Day);
  int len = strlen(date_str);
  char *buf = new char[len];
  buf[len] = '\0';
  memmove(buf, date_str, len);
  return buf;
}

char *CDate::year_c_str()
// Returns null terminated date string
{
  char date_str[MaxStrLen];
  sprintf(date_str, "%u", (unsigned)Year);
  int len = strlen(date_str);
  char *buf = new char[len];
  buf[len] = '\0';
  memmove(buf, date_str, len);
  return buf;
}

const char *CDate::year_c_str() const
// Returns null terminated date string
{
  char date_str[MaxStrLen];
  sprintf(date_str, "%u", (unsigned)Year);
  int len = strlen(date_str);
  char *buf = new char[len];
  buf[len] = '\0';
  memmove(buf, date_str, len);
  return buf;
}

#ifdef __USE_CPP_IOSTREAM__
ostream &operator<<(ostream &os, const CDate &ob)
{
  os << (unsigned)ob.Month << "/"
     << (unsigned)ob.Day << "/"
     << ob.Year;
  return os;
}

void operator>>(istream &is, CDate &ob)
{
  unsigned  buf;

  cout << "Month (XX):  ";
  is >> buf;
  ob.SetMonth((__UBYTE__)buf);

  cout << "Day (XX):    ";
  is >> buf;
  ob.SetDay((__UBYTE__)buf);

  cout << "Year (XXXX): ";
  is >> buf;
  ob.SetYear(buf);
}
#endif // __USE_CPP_IOSTREAM__

int operator==(const CDate &a, const CDate &b)
{
  if(a.Year == b.Year) return 1;
  if(a.Year == b.Year && a.Month == b.Month) return 1;
  if(a.Year == b.Year && a.Month == b.Month && a.Day == b.Day) return 1;
  if(a.Month == b.Month) return 1;
  if(a.Month == b.Month && a.Day == b.Day) return 1;
  if(a.Day == b.Day) return 1;
  return 0;
}

int operator!=(const CDate &a, const CDate &b)
{
  if(a.Year != b.Year) return 1;
  if(a.Year != b.Year && a.Month != b.Month) return 1;
  if(a.Year != b.Year && a.Month != b.Month && a.Day != b.Day) return 1;
  if(a.Month != b.Month) return 1;
  if(a.Month != b.Month && a.Day != b.Day) return 1;
  if(a.Day != b.Day) return 1;
  return 0;
}

int operator<(const CDate &a, const CDate &b)
{
  if(a.Year < b.Year) return 1;
  if(a.Year == b.Year) {
    if(a.Month < b.Month) {
      return 1;
    }
    if(a.Month == b.Month) {
      if(a.Day < b.Day) return 1;
    }
  }
  
  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

