#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program 
# C/C++ Compiler Used: DJGPP gcc 2.7.2.1 compiled for MSDOS 
# Produced By: Doug Gaer
# File Creation Date: 09/21/1997 
# Date Last Modified: 06/07/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v -- Echo compilation
#       g -- Enable debugging
#       Wall -- Turn on warnings 
#       -fhandle-exceptions -- Enable C++ exception handling
#       -frtti              -- Enable C++ Run-Time Type Information
#
# Linker flags using gcc or ld
#	-lgpp    -- C++ Linkage
#	-lstdcx  -- Needed for Exception Handling and RTTI
#	-lm      -- Needed for Exception Handling
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = testprog

# Setup additional paths for includes and source code
BASE_PATH = ../base/
EHANDLER_PATH = ../../ehandler/base/
DTYPES_PATH = ../../dtypes/base/

ADD_INC_PATHS = -I../base -I../../ehandler/base -I../../dtypes/base

# Setup define macros
DEFMACS = -D__CONSOLE__ -D__USE_CPP_IOSTREAM__ #-DCPP_EXCEPTIONS

# Define macros for compiler and linker
CC = gcc
CPP = gcc 
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -fhandle-exceptions $(DEFMACS) $(ADD_INC_PATHS)
COMPILE_ONLY = -c
OUTPUT = -o
CPP_FLAG = -lgpp -lstdcx -lm        
LFLAGS =  

# Build dependency rules
# ===============================================================
EHANDLER_DEP = $(EHANDLER_PATH)ehandler.hpp

UINT16_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)uint16.hpp

CDATE_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)uint16.hpp $(BASE_PATH)cdate.hpp 

TESTPROG_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
		$(DTYPES_PATH)uint16.hpp $(BASE_PATH)cdate.hpp 
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

ehandler.o:	$(EHANDLER_PATH)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(EHANDLER_PATH)ehandler.cpp

testprog.o:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

uint16.o:	$(DTYPES_PATH)uint16.cpp $(UINT16_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)uint16.cpp

cdate.o:    $(BASE_PATH)cdate.cpp $(CDATE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)cdate.cpp

# Make the executable
OBJS = ehandler.o uint16.o cdate.o testprog.o 

$(PROJECT):	$(OBJS)
	$(CC) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) $(CPP_FLAG)
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing COFF file from working directory...
	rm -f $(PROJECT)

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT).exe
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
