#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program  
# C/C++ Compiler Used: Microsoft Visual C/C++ 4.2 
# Produced By: Doug Gae
# File Creation Date: 09/21/1997 
# Date Last Modified: 06/07/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#	Zi -- Enable debugging
#       W3 -- Turn on warnings 
#       GX -- Enable C++ exception handling
#       GR -- Enable C++ Run-Time Type Information
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = testprog

# Setup additional paths for includes and source code
BASE_PATH = ../base/
EHANDLER_PATH = ../../ehandler/base/
DTYPES_PATH = ../../dtypes/base/

ADD_INC_PATHS = /I../base /I../../ehandler/base /I../../dtypes/base

# Setup define macros
DEFMACS = /D__CONSOLE__ /D__USE_CPP_IOSTREAM__ #/DCPP_EXCEPTIONS

# Define macros for compiler and linker
CC = cl
CPP = cl
LINKER = link

# Define compiler and linker flags macros
CFLAGS= /Zi /GX $(DEFMACS) $(ADD_INC_PATHS)
COMPILE_ONLY = /c
LFLAGS =  

# Build dependency rules
# ===============================================================
EHANDLER_DEP = $(EHANDLER_PATH)ehandler.hpp

UINT16_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)uint16.hpp

CDATE_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)uint16.hpp $(BASE_PATH)cdate.hpp 

TESTPROG_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
		$(DTYPES_PATH)uint16.hpp $(BASE_PATH)cdate.hpp 
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT).exe

ehandler.obj:	$(EHANDLER_PATH)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(EHANDLER_PATH)ehandler.cpp

testprog.obj:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

uint16.obj:	$(DTYPES_PATH)uint16.cpp $(UINT16_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)uint16.cpp

cdate.obj:    $(BASE_PATH)cdate.cpp $(CDATE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)cdate.cpp

# Make the executable
OBJS = ehandler.obj uint16.obj cdate.obj testprog.obj 
 
$(PROJECT).exe:	$(OBJS)
	$(LINKER) $(LFLAGS) $(OBJS) /OUT:$@ 
# ===============================================================

# Remove OBJS, debug files, and executable after running nmake 
# ===============================================================
clean:
	@echo Removing all .SBR files from working directory...
	if exist *.sbr del *.sbr  

	@echo Removing all .VCW files from working directory...
	if exist *.vcw del *.vcw 

	@echo Removing all .PDB files from working directory...
	if exist *.pdb del *.pdb 

	@echo Removing all .WSP files from working directory...
	if exist *.wsp del *.wsp 

	@echo Removing all .BSC files from working directory...
	if exist *.bsc del *.bsc 

	@echo Removing all .SBT files from working directory...
	if exist *.sbt del *.sbt 

	@echo Removing all .ILK files from working directory...
	if exist *.ilk del *.ilk 

	@echo Removing all .IDB files from working directory...
	if exist *.idb del *.idb 

	@echo Removing all .MDP files from working directory...
	if exist *.mdp del *.mdp 

	@echo Removing all .PCH files from working directory...
	if exist *.pch del *.pch 

	@echo Removing all .NCB files from working directory...
	if exist *.ncb del *.ncb 

	@echo Removing all .OBJ files from working directory...
	if exist *.obj del *.obj 

	@echo Removing the EXECUTABLE file from working directory
	if exist $(PROJECT).exe del $(PROJECT).exe 
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################


