// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// C++ Compiler Used: Microsoft Visual C/C++ 4.2  
// Produced By: Doug Gaer
// File Creation Date: 12/29/1996
// Date Last Modified: 07/30/1998
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This is a test program for the character string doubly
linked list implementation.

The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include "chlist.hpp"

void pause()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

inline void PrintList(ChList &List)
// Prints out the members of the list.
// Assumes TYPE can be written to output stream.
{
  ChNode *ptr = List.GetFront();
  while(!List.IsHeader(ptr)) {
    cout << ptr->Data << endl;
    ptr = ptr->GetNext(); 
  }
}

inline void RewindList(ChList &List)
// Prints out the members of the list.
// Assumes TYPE can be written to output stream.
{
  ChNode *ptr = List.GetBack();
  while(!List.IsHeader(ptr)) {
    cout << ptr->Data << endl;
    ptr = ptr->GetPrior(); 
  }
}

main()
{
  ChList a, b;
  ChNode *ptr;

  a.Store("The quick brown fox jumps over the lazy dog");
  a.Store("0123456789");
  a.Store("abcdefghijklmnopqrstuvwxyz");
  a.Store("!@#$%^&*()_+");
    
  cout << "Adding nodes to list ""a""..." << endl;
  
  cout << endl;
  PrintList(a);

  cout << endl;
  cout << "Adding nodes to list ""b""..." << endl;
  b.Store("The quick brown fox jumps over the lazy dog");
  b.Store("0123456789");
  b.Store("abcdefghijklmnopqrstuvwxyz");
  b.Store("!@#$%^&*()_+");

  cout << endl;
  PrintList(b);

  pause();
  
  cout << "Rewinding list ""b""..." << endl;
  cout << endl;
  RewindList(b);
  
  pause();

  cout << "Testing copy constructor..." << endl;
  ChList c(b);

  cout << endl;
  PrintList(c);
  
  pause();

  cout << "Testing assignment operator..." << endl;
  ChList d;
  d = a;

  cout << endl;
  PrintList(d);

  pause();
  
  cout << "Testing concatenation functions..." << endl;
  a += b;

  cout << endl;
  PrintList(a);

  c.Cat(d);

  cout << endl;
  PrintList(c);
  
  pause();

  cout << "Testing Find function..." << endl;
  cout << "Looking for alphabet string..." << endl;

  ptr = (ChNode *)a.Find("abcdefghijklmnopqrstuvwxyz");
  if(ptr) cout << "Found: " << ptr->Data << " string." << endl;

  pause();

  cout << "Testing add functions..." << endl;
  a.Clear();
  
  ptr = a.AddToBack("DOG");
  a.AddToBack("CAT");
  a.AddBefore("COW", ptr);
  a.AddAfter("BIRD", ptr);
  a.AddToFront("MOUSE");

  PrintList(a);
  
  pause();

  cout << "Testing delete functions..." << endl;
  ptr = (ChNode *)a.Find("COW");
  if(ptr) a.Delete(ptr);
  PrintList(a);
  cout << endl;
  a.DeleteFront();
  PrintList(a);
  cout << endl;
  a.DeleteBack();
  PrintList(a);

  pause();

  cout << "Testing GetNode functions..." << endl;
  cout << *a.GetFrontNode() << endl;
  cout << *a.GetBackNode() << endl;

  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
