// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: chslist.cpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer 
// File Creation Date: 12/29/1996
// Date Last Modified: 07/30/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

A character string singly linked list class derived from the
SNodeBase class and the SLListBase class.
*/
// ----------------------------------------------------------- // 
#include <string.h>
#include "chslist.hpp"

ChSList::~ChSList()
{
  Clear();
}

int ChSList::Copy(const ChSList &List)
{
  return SLListBase::Copy(List);
}

ChSNode *ChSList::AllocNode(const SLTYPE &X)
{
  return new ChSNode(X);
}

SNodeBase *ChSList::DupNode(const SNodeBase *Node)
{
  return AllocNode(((ChSNode *)Node)->Data);
}

void ChSList::FreeNode(SNodeBase *Node)
{
  delete((ChSNode *)Node);
}

const ChSNode *ChSList::Find(const SLTYPE &X, const ChSNode *ptr) const
// Returns the first node having an element that matched X
{
  if(ptr == 0) ptr = GetFront();

  while(!IsHeader(ptr)) { // Scan until end of list
    if(strcmp(ptr->Data, X) == 0) return ptr; // Match found
    ptr = ptr->GetNext();
  }
  return 0; // No match
}

ChSNode *ChSList::Find(const SLTYPE &X, ChSNode *ptr)
// Returns the first node having an element that matched X
{
  if(ptr == 0) ptr = GetFront();

  while(!IsHeader(ptr)) { // Scan until end of list
    if(strcmp(ptr->Data, X) == 0) return ptr; // Match found
    ptr = ptr->GetNext();
  }
  return 0; // No match
}

int ChSList::DeleteNext(ChSNode *Node, SLTYPE *X)
{
  ChSNode *ptr = RmvNext(Node);
  if(ptr) {
    if(X) *X = ptr->Data; // Copy Data into X if X != 0
    FreeNode(ptr);
    return 1; // Return 1 if successful
  }
  return 0; 
}

int ChSList::DeleteFront(SLTYPE *X)
{
  ChSNode *ptr = RmvFront();
  if(ptr) {
    if(X) *X = ptr->Data; // Copy Data into X if X != 0
    FreeNode(ptr);
    return 1; // Return 1 if successful
  }
  return 0; 
}

ChSNode *ChSList::Store(const SLTYPE &X)
{
  ChSNode *ptr = AllocNode(X);
  if(ptr) AttachToBack(ptr);
  return ptr; // Return a pointer to the node added
}

ChSNode *ChSList::AddToFront(const SLTYPE &X)
{
  ChSNode *ptr = AllocNode(X);
  if(ptr) AttachToFront(ptr);
  return ptr; // Return a pointer to the node added
}

ChSNode *ChSList::AddToBack(const SLTYPE &X)
{
  ChSNode *ptr = AllocNode(X);
  if(ptr) AttachToBack(ptr);
  return ptr; // Return a pointer to the node added
}

ChSNode *ChSList::AddAfter(const SLTYPE &X, ChSNode *Node)
{
  ChSNode *ptr = AllocNode(X);
  if(ptr) InsertAfter(Node, ptr);
  return ptr; // Return a pointer to the node added
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
