// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: chslist.hpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer
// File Creation Date: 12/29/1996
// Date Last Modified: 07/30/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

A character string singly linked list class derived from the
SNodeBase class and the SLListBase class.
*/
// ----------------------------------------------------------- //   
#ifndef __CHSLIST_HPP
#define __CHSLIST_HPP

#include "sllistb.hpp"

// General definition of the concrete data type used
typedef char * SLTYPE;

// (C)haracter (B)ased (S)ingly Linked List (N)ode class 
class ChSNode: public SNodeBase
{
public:
  ChSNode() { } // Implicitly call default constructor for Data
  ChSNode(const SLTYPE &X) : Data(X) { } // Call copy constructor

public:
  ChSNode *GetNext() { return (ChSNode *)Next; }
  const ChSNode *GetNext() const { return (ChSNode *)Next; }

public:
  SLTYPE Data;
};

// (C)haracter (B)ased (S)ingly (L)inked (L)ist class 
class ChSList : public SLListBase
{
public:
  ChSList() { }
  virtual ~ChSList();
  ChSList(const ChSList &X) { Copy(X); }
  void operator=(const ChSList &X) { Copy(X); }

public:
  int Copy(const ChSList &List);
  int Cat(const ChSList &X) { return SLListBase::Cat(X); }
  const ChSNode *Find(const SLTYPE &X, const ChSNode *ptr=0) const;
  ChSNode *Find(const SLTYPE &X, ChSNode *ptr=0);
  int DeleteNext(ChSNode *Node, SLTYPE *X = 0);
  int DeleteFront(SLTYPE *X = 0);
  ChSNode *Store(const SLTYPE &X);
  ChSNode *AddToFront(const SLTYPE &X);
  ChSNode *AddToBack(const SLTYPE &X);
  ChSNode *AddAfter(const SLTYPE &X, ChSNode *Node);
  ChSNode *GetHeader() { return(ChSNode *) this; }
  const ChSNode *GetHeader() const { return(ChSNode *) this; }
  ChSNode *GetFront() { return(ChSNode *)SLListBase::GetFront(); }
  ChSNode *GetBack() { return (ChSNode *)SLListBase::GetBack(); }
  
  const ChSNode *GetFront() const { // Read only version
    return(ChSNode *)SLListBase::GetFront();
  }

  const ChSNode *GetBack() const { // Read only version
    return (ChSNode *)SLListBase::GetBack();
  }

  int IsHeader(const ChSNode *Node) const {
    return SLListBase::IsHeader(Node);
  }
  SLTYPE *GetFrontNode() {
    ChSNode *ptr = (ChSNode *)SLListBase::GetFront();
    return IsHeader(ptr) ? 0 : &(ptr->Data);
  }

  const SLTYPE *GetFrontNode() const {
    ChSNode *ptr = (ChSNode *)SLListBase::GetFront();
    return IsHeader(ptr) ? 0 : &(ptr->Data);
  }

  SLTYPE *GetBackNode() {
    ChSNode *ptr = (ChSNode *)SLListBase::GetBack();
    return IsHeader(ptr) ? 0 : &(ptr->Data);
  }

  const SLTYPE *GetBackNode() const {
    ChSNode *ptr = (ChSNode *)SLListBase::GetBack();
    return IsHeader(ptr) ? 0 : &(ptr->Data);
  }

public:
  void InsertAfter(ChSNode *A, ChSNode *B) {
    SLListBase::InsertAfter(A, B);
  }

  void AttachToFront(ChSNode *Node) {
    SLListBase::AttachToFront(Node);
  }

  void AttachToBack(ChSNode *Node) {
    SLListBase::AttachToBack(Node);
  }

  ChSNode *RmvFront() {
    return(ChSNode *)(SLListBase::RmvFront());
  }

  ChSNode *RmvNext(ChSNode *Node) {
    return(ChSNode *)(SLListBase::RmvNext(Node));
  }

protected:
  virtual ChSNode *AllocNode(const SLTYPE &X);
  virtual SNodeBase *DupNode(const SNodeBase *Node);
  virtual void FreeNode(SNodeBase *Node);

public: // Overloaded operators
  int operator+=(const ChSList &X) { return Cat(X); }
};

#endif  // __CHSLIST_HPP 
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
