// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Header File Name: config.hpp
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer  
// File Creation Date: 02/19/1996 
// Date Last Modified: 07/30/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The Config class is a character string based singly linked list
that is used to load program parameters from a ASCII text based
configuration file.
*/
// ----------------------------------------------------------- // 
#ifndef __CONFIG_HPP
#define __CONFIG_HPP

#include "chslist.hpp"

class ConfigData
{
private:
  friend class Config;

private:
  char *Name;
  char *Value;
};

class Config : private ChSList
{
public:
  Config() { }
  ~Config();

private:
  Config(const Config &ob) { }         // Disallow copying
  void operator=(const Config &ob) { } // Disallow assignment

public:
  int Load(char *Fname); 
  void UnLoad();
  char* GetStrValue(char *Name);  // Character string values
  int GetIntValue(char *Name);    // Integer values
  double GetDFPValue(char *Name); // Double precision floating point values
  long GetLongValue(char *Name);  // Long integer values
  
private:
  int StoreCfgData(char *str);

private:
  // No Data
};

#endif // __CONFIG_HPP
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

