#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program 
# C/C++ Compiler Used: GNU g++ 2.7.2.1 
# Produced By: Doug Gaer
# File Creation Date: 04/04/1997 
# Date Last Modified: 01/17/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v -- Echo compilation
#       g -- Enable debugging
#       Wall -- Turn on warnings 
#
# --------------------------------------------------------------- 
SHELL = /bin/sh

# Define a name for the executable
PROJECT = testprog

# Setup additional paths for includes and source code
BASE_PATH = ../base/
SLLISTB_PATH = ../../sllist/base/
CHSLIST_PATH = ../../chslist/base/

ADD_INC_PATHS = -I../base -I../../sllist/base -I../../chslist/base

# Setup define macros
DEFMACS = 

# Define macros for compiler and linker
CC = gcc
CPP = g++ 
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -v -Wall $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
LFLAGS =  

# Build dependency rules
# ===============================================================
CHSLIST_DEP = $(CHSLIST_PATH)chslist.hpp $(SLLISTB_PATH)sllistb.hpp

CONFIG_DEP = $(CHSLIST_PATH)chslist.hpp $(BASE_PATH)config.hpp \
	$(SLLISTB_PATH)sllistb.hpp

SLLISTB_DEP = $(SLLISTB_PATH)sllistb.hpp

TESTPROG_DEP = $(CHSLIST_PATH)chslist.hpp $(BASE_PATH)config.hpp \
	$(SLLISTB_PATH)sllistb.hpp 
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT) 

chslist.o:	$(CHSLIST_PATH)chslist.cpp $(CHSLIST_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CHSLIST_PATH)chslist.cpp

config.o:	$(BASE_PATH)config.cpp $(CONFIG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)config.cpp

sllistb.o:	$(SLLISTB_PATH)sllistb.cpp $(SLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(SLLISTB_PATH)sllistb.cpp

testprog.o:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

# Make the executable
OBJS = chslist.o config.o sllistb.o testprog.o 

$(PROJECT):	$(OBJS)
	$(CPP) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) 
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT)

# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
