// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer  
// File Creation Date: 02/19/1996 
// Date Last Modified: 01/17/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This is a test program for the Config class.

The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include "config.hpp"

main()
{
  Config *CfgData = new Config;
  int Status;
  
  cout << "Loading Config File..." << endl;
  Status = CfgData->Load("config.ini");
  if(!Status) {
    cout << "Config file not found!" << endl;
    return 0;
  }

  cout << endl;
  char *v1 = CfgData->GetStrValue("String");
  if(!v1)
    cout << "String section missing from config file" << endl;
  else  cout << "String section of config file = " << v1 << endl;

  int v2 = CfgData->GetIntValue("Int");
  if(!v2)
    cout << "Int section missing from config file" << endl;
  else  cout << "Integer section of config file = " << v2 << endl;

  double v3 = CfgData->GetDFPValue("Float");
  if(!v3)
    cout << "Float section missing from config file" << endl;
  else  cout << "Floating Point number section of config file = "
	     << v3 << endl;

  long v4 = CfgData->GetLongValue("Long");
  if(!v4)
    cout << "Long int section missing from config file" << endl;
  else  cout << "Long int section of config file = "
	     << v4 << endl;

  cout << endl;
  cout << "Unloading Config file" << endl;
  CfgData->UnLoad();

  cout << endl;
  cout << "Checking for memory leaks" << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();

  cout << endl;
  v1 = CfgData->GetStrValue("String");
  if(!v1)
    cout << "String section missing from config file" << endl;
  else  cout << "String section of config file = " << v1 << endl;

  v2 = CfgData->GetIntValue("Int");
  if(!v2)
    cout << "Int section missing from config file" << endl;
  else  cout << "Integer section of config file = " << v2 << endl;

  v3 = CfgData->GetDFPValue("Float");
  if(!v3)
    cout << "Float section missing from config file" << endl;
  else  cout << "Floating Point number section of config file = "
	     << v3 << endl;

  v4 = CfgData->GetLongValue("Long");
  if(!v4)
    cout << "Long int section missing from config file" << endl;
  else  cout << "Long int section of config file = "
	     << v4 << endl;

  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
