// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: dllistb.hpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer
// File Creation Date: 12/29/1996
// Date Last Modified: 07/30/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

Base classes for doubly linked list implementations. The
DNodeBase class and the DLListBase class separates the nodes
from the data stored in the list by storing pointer to the
data. Classes derived from these base classes can deal with
any type of node data.
*/
// ----------------------------------------------------------- //   
#ifndef __DLLISTB_HPP
#define __DLLISTB_HPP

// (D)oubly Linked List (N)ode (B)ase class 
class DNodeBase
{
protected:
  friend class DLListBase;

protected:
  void InsertAfter(DNodeBase *Node);
  void InsertBefore(DNodeBase *Node);
  DNodeBase *Rmv();
  void SelfRef() { Prior = this; Next = this; }

protected:
  DNodeBase *Prior;
  DNodeBase *Next;
};

// (D)oubly (L)inked (L)ist (B)ase class  
class DLListBase : public DNodeBase
{
protected:
  DLListBase() { MakeEmpty(); }
  virtual ~DLListBase(); 

public:
  virtual void Clear();
  int IsEmpty() const { return (const DNodeBase *)Next == this; }
  int IsHeader(const DNodeBase *Node) const { return Node == this; }
  
protected:
  virtual DNodeBase *DupNode(const DNodeBase *Node) = 0;
  virtual void FreeNode(DNodeBase *Node) = 0;
  virtual void MakeEmpty(); 
  DNodeBase *GetHeader() { return this; }
  const DNodeBase *GetHeader() const { return this; }
  DNodeBase *GetFront() { return Next; }
  const DNodeBase *GetFront() const { return Next; }
  DNodeBase *GetBack() { return Prior; }
  const DNodeBase *GetBack() const { return Prior; }
  void InsertBefore(DNodeBase *A, DNodeBase *B) {
    A->InsertBefore(B); }
  void InsertAfter(DNodeBase *A, DNodeBase *B) {
    A->InsertAfter(B); }
  void AttachToFront(DNodeBase *Node) { InsertAfter(this, Node); }
  void AttachToBack(DNodeBase *Node) { InsertAfter(Prior, Node); }
  DNodeBase *Rmv(DNodeBase *Node);
  DNodeBase *RmvFront() { return Rmv(Next); }
  DNodeBase *RmvBack() { return Rmv(Prior); }
  int Copy(const DLListBase &List);
  int Cat(const DLListBase &List);
};

#endif  // __DLLISTB_HPP //
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
