#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program 
# C/C++ Compiler Used: DJGPP gcc 2.7.2.1 compiled for MSDOS 
# Produced By: Doug Gaer
# File Creation Date: 04/03/1997 
# Date Last Modified: 01/17/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v -- Echo compilation
#       g -- Enable debugging
#       Wall -- Turn on warnings 
#
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = testprog

# Setup additional paths for includes and source code
BASE_PATH = ../base/
USTRING_PATH = ../../ustring/base/

ADD_INC_PATHS = -I../base -I../../ustring/base

# Setup define macros
DEFMACS = 

# Define macros for compiler and linker
CC = gcc
CPP = gcc 
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -v -g -Wall $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
CPP_FLAG = -lgpp     
LFLAGS =  

# Build dependency rules
# ===============================================================
DLLISTB_DEP = $(BASE_PATH)dllistb.hpp

TESTPROG_DEP = $(BASE_PATH)dllist.hpp $(BASE_PATH)dllistb.hpp \
	$(USTRING_PATH)ustring.hpp

USTRING_DEP = $(USTRING_PATH)ustring.hpp
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT) 

dllistb.o:	$(BASE_PATH)dllistb.cpp $(DLLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)dllistb.cpp

testprog.o:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

ustring.o:	$(USTRING_PATH)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(USTRING_PATH)ustring.cpp

# Make the executable
OBJS = dllistb.o testprog.o ustring.o

$(PROJECT):	$(OBJS)
	$(CC) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) $(CPP_FLAG)
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing COFF file from working directory...
	rm -f $(PROJECT)

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT).exe
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
