// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: fkey.cpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 02/07/1997  
// Date Last Modified: 02/02/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The FKey class is used to identify objects in the database
by a unique key name when an index file is used. Each key is
fixed in length by the FKeyLength variable.
*/
// ----------------------------------------------------------- //   

#include "fkey.hpp"

FKey::FKey(char *s)
{
  strncpy(key_name, s, FKeyLength); key_name[FKeyLength-1] = 0;
  object_address = 0; class_id = 0; 
}

FKey::FKey(char *s, int oa, int ci)
{
  strncpy(key_name, s, FKeyLength); key_name[FKeyLength-1] = 0;
  object_address = oa;
  class_id = ci;
}

FKey::FKey(const FKey &s)
{
  Copy(s);
  object_address = s.object_address;
  class_id = s.class_id;
}

FKey &FKey::operator=(const FKey &s)
{
    if(this != &s) {
      Copy(s);
      object_address = s.object_address;
      class_id = s.class_id;
    }
    return *this;
}

void FKey::Clear()
{
  for(unsigned i = 0; i < FKeyLength; i++)
    key_name[i] = 0;
}

int FKey::Append(char c)
// Returns the position of the appended character
{
  int pos = 0;
  for(int i = 0; key_name[i] != '\0'; i++) 
      pos++;

  if(pos == FKeyLength) return FKeyLength; // At the end of the string

  key_name[pos] = c;
  key_name[++pos] = '\0'; // Ensure the last byte is null
  return pos;
}

void FKey::Copy(const FKey &s)
{
  Clear();
  strcpy(key_name, s.key_name);
}

char *FKey::c_str()
{
  char *buf = new char[FKeyLength+1];
  buf[FKeyLength] = '\0';
  memcpy(buf, key_name, FKeyLength);
  return buf;
}

char *FKey::c_str() const
{
  char *buf = new char[FKeyLength+1];
  buf[FKeyLength] = '\0';
  memcpy(buf, key_name, FKeyLength);
  return buf;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

