// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: tnode.hpp 
// Compiler Used: MSVC40, DJGPP 2.7.2.1, GCC 2.7.2.1, HP CPP 10.24
// Produced By: Doug Gaer   
// File Creation Date: 02/07/1997  
// Date Last Modified: 02/02/1998
// Copyright (c) 1997 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
All those who put this code or its derivatives in a commercial
product MUST mention this copyright in their documentation for
users of the products in which this code or its derivative
classes are used. Otherwise, you have the freedom to redistribute
verbatim copies of this source code, adapt it to your specific
needs, or improve the code and release your improvements to the
public provided that the modified files carry prominent notices
stating that you changed the files and the date of any change.

THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND.
THE ENTIRE RISK OF THE QUALITY AND PERFORMANCE OF THIS SOFTWARE
IS WITH YOU. SHOULD ANY ELEMENT OF THIS SOFTWARE PROVE DEFECTIVE,
YOU WILL ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR, OR
CORRECTION.

The TNode class is used to create Disk-based binary search 
nodes of specific data type.
*/
// ----------------------------------------------------------- //   
#ifndef __TNODE_HPP
#define __TNODE_HPP

#include "fkey.hpp"

// NOTE: To avoid portablity problems with template classes, enable
// the __NOT_USING_TEMPLATE_CLASS__ macro and directly code the
// Bucket class, Cache class, and the CachePtr class for the data
// type that will be used.

// Default to using template class
#ifndef __NOT_USING_TEMPLATE_CLASS__
#define __USING_TEMPLATE_CLASS__
#endif

#ifdef __NOT_USING_TEMPLATE_CLASS__
#include "vbdfile.hpp"
#endif

#ifdef __USING_TEMPLATE_CLASS__
#include "cacheptr.hpp"
#endif

// General definition of the Disk-based Tree (D)ata (T)ype
#ifndef DTYPE
typedef FKey DTYPE;
#endif

// (T)ree (N)ode class (Disk-based binary search nodes)
class TNode 
{ 
public:
  TNode() { Left = 0; Right = 0; }
  TNode(const DTYPE &X);

public:
  DTYPE Data; 
  FAU Left;   
  FAU Right;
};

#ifdef __USING_TEMPLATE_CLASS__
typedef CachePtr<TNode> CachePointer; // Pointer to cache
#endif

#endif  // __TNode_HPP //
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
