#######################
#### Start of File ####
#######################
# --------------------------------------------------------------- 
# Makefile Contents: Makefile for the test program 
# C/C++ Compiler Used: DJGPP gcc 2.7.2.1 compiled for MSDOS 
# Produced By: Doug Gaer
# File Creation Date: 04/14/1997 
# Date Last Modified: 09/18/1998 
# --------------------------------------------------------------- 
# --------------- Makefile Description and Details -------------- 
# --------------------------------------------------------------- 
# Complier Flags 
#       v -- Echo compilation
#       g -- Enable debugging
#       Wall -- Turn on warnings 
#       -fhandle-exceptions -- Enable C++ exception handling
#       -frtti              -- Enable C++ Run-Time Type Information
#
# Linker flags using gcc or ld
#	-lgpp    -- C++ Linkage
#	-lstdcx  -- Needed for Exception Handling and RTTI
#	-lm      -- Needed for Exception Handling
# --------------------------------------------------------------- 
# Define a name for the executable
PROJECT = testprog

# Setup additional paths for includes and source code
BASE_PATH = ../base/
CACHE_PATH = ../../cache/base/
EHANDLER_PATH = ../../ehandler/base/
DTYPES_PATH = ../../dtypes/base/
VBDFILE_PATH = ../../vbdfile/base/
REFCOUNT_PATH = ../../refcount/base/
PLACENEW_PATH = ../../placenew/base/
CRC32_PATH = ../../crc32/base/

ADD_INC_PATHS = -I../base -I../../ehandler/base -I../../dtypes/base \
-I../../vbdfile/base -I../../pod/base -I../../refcount/base \
-I../../cache/base -I../../placenew/base -I../../crc32/base

# Alloaction method used to reclaim deleted blocks
DEF_VB_ALLOC = -D__RECLAIM_BEST_FIT__ 
#DEF_VB_ALLOC = -D__RECLAIM_FIRST_FIT__ 

# Use this DEFMACS macro to compile without using template classes
# DEFMACS = -D__NOT_USING_TEMPLATE_CLASS__ -D__DTREE_NODE__ -D__CONSOLE__ \
# -D__USE_VBDREFCOUNT__ $(DEF_VB_ALLOC) # -DCPP_EXCEPTIONS

# Enable to use the template classes
DEFMACS = -D__CONSOLE__ $(DEF_VB_ALLOC) # -DCPP_EXCEPTIONS

# Define macros for compiler and linker
CC = gcc
CPP = gcc 
LINKER = ld

# Define compiler and linker flags macros
CFLAGS= -fhandle-exceptions $(ADD_INC_PATHS) $(DEFMACS)
COMPILE_ONLY = -c
OUTPUT = -o
CPP_FLAG = -lgpp -lstdcx -lm        
LFLAGS =  

# Build dependency rules
# ===============================================================
CRC32_DEP = $(CRC32_PATH)crc32.hpp $(CRC32_PATH)crc32tab.hpp

UINT32_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)uint32.hpp

BUCKET_DEP = $(CACHE_PATH)bucket.hpp $(CACHE_PATH)cacheb.hpp \
	$(CACHE_PATH)cactype.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(VBDFILE_PATH)vbdfile.hpp $(BASE_PATH)tnode.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(BASE_PATH)fkey.hpp \
	$(DTYPES_PATH)uint32.hpp

CACHE_DEP = $(CACHE_PATH)bucketb.hpp $(CACHE_PATH)cacheb.hpp \
	$(CACHE_PATH)cactype.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(VBDFILE_PATH)vbdfile.hpp $(BASE_PATH)tnode.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(BASE_PATH)fkey.hpp \
	$(DTYPES_PATH)uint32.hpp

CACHEB_DEP = $(CACHE_PATH)bucketb.hpp $(CACHE_PATH)cacheb.hpp \
	$(EHANDLER_PATH)ehandler.hpp $(VBDFILE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(DTYPES_PATH)int32.hpp \
	$(DTYPES_PATH)dtypes.hpp $(DTYPES_PATH)uint32.hpp

CACSTATS_DEP = $(CACHE_PATH)bucketb.hpp $(CACHE_PATH)cacheb.hpp \
	$(EHANDLER_PATH)ehandler.hpp $(VBDFILE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(DTYPES_PATH)int32.hpp \
	$(DTYPES_PATH)dtypes.hpp $(CACHE_PATH)cacstats.hpp \
	$(DTYPES_PATH)uint32.hpp

CHPTRB_DEP = $(CACHE_PATH)bucket.hpp $(CACHE_PATH)bucketb.hpp \
	$(CACHE_PATH)cache.hpp $(CACHE_PATH)cacheb.hpp \
	$(CACHE_PATH)chptrb.hpp $(CACHE_PATH)cactype.hpp\
	$(EHANDLER_PATH)ehandler.hpp $(VBDFILE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(DTYPES_PATH)int32.hpp \
	$(DTYPES_PATH)dtypes.hpp $(DTYPES_PATH)uint32.hpp

TNODE_DEP = $(BASE_PATH)tnode.hpp $(CACHE_PATH)cacheptr.hpp \
	$(CACHE_PATH)chptrb.hpp $(CACHE_PATH)cache.hpp \
	$(PLACENEW_PATH)placenew.hpp $(CACHE_PATH)bucket.hpp \
	$(CACHE_PATH)bucketb.hpp $(CACHE_PATH)cacheb.hpp \
	$(VBDFILE_PATH)vbdfile.hpp $(REFCOUNT_PATH)refcount.hpp \
	$(EHANDLER_PATH)ehandler.hpp $(DTYPES_PATH)int32.hpp \
	$(DTYPES_PATH)dtypes.hpp $(BASE_PATH)fkey.hpp \
	$(DTYPES_PATH)uint32.hpp

FKEY_DEP = $(BASE_PATH)tnode.hpp $(CACHE_PATH)cacheptr.hpp \
	$(CACHE_PATH)chptrb.hpp $(CACHE_PATH)cache.hpp \
	$(PLACENEW_PATH)placenew.hpp $(CACHE_PATH)bucket.hpp \
	$(CACHE_PATH)bucketb.hpp $(CACHE_PATH)cacheb.hpp \
	$(VBDFILE_PATH)vbdfile.hpp $(REFCOUNT_PATH)refcount.hpp \
	$(CACHE_PATH)cactype.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp $(DTYPES_PATH)dtypes.hpp \
	$(BASE_PATH)fkey.hpp $(DTYPES_PATH)uint32.hpp

DTREE_DEP = $(CACHE_PATH)bucket.hpp $(CACHE_PATH)bucketb.hpp \
	$(CACHE_PATH)cache.hpp $(CACHE_PATH)cacheb.hpp \
	$(CACHE_PATH)chptrb.hpp $(CACHE_PATH)cactype.hpp\
	$(CACHE_PATH)cacheptr.hpp $(BASE_PATH)dtree.hpp \
	$(EHANDLER_PATH)ehandler.hpp $(VBDFILE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(PLACENEW_PATH)placenew.hpp \
	$(BASE_PATH)tnode.hpp $(DTYPES_PATH)int32.hpp\
	$(DTYPES_PATH)dtypes.hpp $(BASE_PATH)fkey.hpp \
	$(DTYPES_PATH)uint32.hpp

EHANDLER_DEP = $(EHANDLER_PATH)ehandler.hpp

INT32_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp

VBDFILE_DEP = $(DTYPES_PATH)dtypes.hpp $(EHANDLER_PATH)ehandler.hpp \
	$(DTYPES_PATH)int32.hpp $(VBDFILE_PATH)vbdfile.hpp \
	$(REFCOUNT_PATH)refcount.hpp $(DTYPES_PATH)uint32.hpp \
	$(CRC32_PATH)crc32.hpp

VBDREF_DEP = $(VBDFILE_PATH)vbdfile.hpp \
	$(VBDFILE_PATH)vbdref.hpp $(REFCOUNT_PATH)refcount.hpp

TESTPROG_DEP = $(CACHE_PATH)bucket.hpp $(CACHE_PATH)bucketb.hpp \
	$(CACHE_PATH)cache.hpp $(CACHE_PATH)cacheb.hpp \
	$(CACHE_PATH)chptrb.hpp $(CACHE_PATH)cacheptr.hpp \
	$(CACHE_PATH)cactype.hpp $(BASE_PATH)dtree.hpp \
	$(EHANDLER_PATH)ehandler.hpp $(DTYPES_PATH)int32.hpp \
        $(VBDFILE_PATH)vbdfile.hpp $(REFCOUNT_PATH)refcount.hpp \
	$(PLACENEW_PATH)placenew.hpp $(BASE_PATH)tnode.hpp \
	$(BASE_PATH)fkey.hpp $(DTYPES_PATH)uint32.hpp
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)

uint32.o:	$(DTYPES_PATH)uint32.cpp $(UINT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)uint32.cpp

crc32.o:	$(CRC32_PATH)crc32.cpp $(CRC32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CRC32_PATH)crc32.cpp

bucket.o:	$(CACHE_PATH)bucket.cpp $(BUCKET_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)bucket.cpp

cache.o:	$(CACHE_PATH)cache.cpp $(CACHE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)cache.cpp

cacheb.o:	$(CACHE_PATH)cacheb.cpp $(CACHEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)cacheb.cpp

chptrb.o:	$(CACHE_PATH)chptrb.cpp $(CHPTRB_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)chptrb.cpp

cacstats.o:	$(CACHE_PATH)cacstats.cpp $(CACSTATS_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(CACHE_PATH)cacstats.cpp

tnode.o:	$(BASE_PATH)tnode.cpp $(TNODE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)tnode.cpp

fkey.o:	$(BASE_PATH)fkey.cpp $(FKEY_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)fkey.cpp

dtree.o:	$(BASE_PATH)dtree.cpp $(DTREE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(BASE_PATH)dtree.cpp

ehandler.o:	$(EHANDLER_PATH)ehandler.cpp $(EHANDLER_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(EHANDLER_PATH)ehandler.cpp

int32.o:	$(DTYPES_PATH)int32.cpp $(INT32_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(DTYPES_PATH)int32.cpp

vbdfile.o:    $(VBDFILE_PATH)vbdfile.cpp $(VBDFILE_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) $(VBDFILE_PATH)vbdfile.cpp

vbdref.o:	$(VBDFILE_PATH)vbdref.cpp $(VBDREF_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) \
	$(VBDFILE_PATH)vbdref.cpp

testprog.o:	testprog.cpp $(TESTPROG_DEP)
	$(CPP) $(COMPILE_ONLY) $(CFLAGS) testprog.cpp

# Make the executable
OBJS = cacheb.o chptrb.o dtree.o ehandler.o vbdfile.o \
	testprog.o tnode.o int32.o bucket.o cache.o \
	fkey.o vbdref.o cacstats.o crc32.o uint32.o

$(PROJECT):	$(OBJS)
	$(CC) $(CFLAGS) $(OBJS) $(OUTPUT) $(PROJECT) $(CPP_FLAG)
# ===============================================================

# Remove object files and the executable after running make 
# ===============================================================
clean:
	echo Removing all OBJECT files from working directory...
	rm -f *.o 

	echo Removing COFF file from working directory...
	rm -f $(PROJECT)

	echo Removing EXECUTABLE file from working directory...
	rm -f $(PROJECT).exe

	echo Removing any test files created during program execution
	rm -f testfile.dtx
# --------------------------------------------------------------- 
#####################
#### End of File ####
#####################
